/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorMailSweeper {
    private List ignoreList;
    private String outputFileName;
    private String targetDir;
    private boolean delete;
    private PrintWriter pw;
    private Pattern emailPattern = Pattern.compile("\nTo: ([\\w\\-.]+@[\\w\\-.]+\\.(com|net|org|jp|to))\n", 2);
    private Pattern tempPattern = Pattern.compile("temporarily", 2);

    public ErrorMailSweeper() {
        this.ignoreList = new ArrayList();
    }

    public void addIgnoreAddress(String string) {
        this.ignoreList.add(string);
    }

    public void setTargetDir(String string) {
        this.targetDir = string;
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string;
    }

    public void deleteLater(boolean bl) {
        this.delete = bl;
    }

    public void execute() {
        File file = new File(this.targetDir);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    boolean bl = this.scanFile(fileArray[i]);
                    if (!bl || !this.delete) continue;
                    fileArray[i].delete();
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (this.pw != null) {
                this.pw.close();
            }
        }
    }

    protected boolean scanFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return this.searchAddress(stringBuffer.toString());
    }

    protected boolean searchAddress(String string) throws IOException {
        Matcher matcher = this.tempPattern.matcher(string);
        if (matcher.find()) {
            return false;
        }
        matcher = this.emailPattern.matcher(string);
        boolean bl = false;
        block0: while (matcher.find()) {
            for (int i = 0; i < this.ignoreList.size(); ++i) {
                String string2 = (String)this.ignoreList.get(i);
                if (matcher.group(1).matches(string2)) continue block0;
            }
            this.output(matcher.group(1));
            bl = true;
        }
        return bl;
    }

    protected void output(String string) throws IOException {
        if (this.pw == null) {
            this.pw = new PrintWriter(new BufferedWriter(new FileWriter(this.outputFileName, true)));
        }
        this.pw.println(string);
    }

    private static void printUsage() {
        System.out.println("Usage: java com.ozacc.bulkmail.ErrorMailSweeper -d <input directory> -f <output file> [-i <email>] [--delete]");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            ErrorMailSweeper.printUsage();
            return;
        }
        ErrorMailSweeper errorMailSweeper = new ErrorMailSweeper();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d")) {
                errorMailSweeper.setTargetDir(stringArray[i + 1]);
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-f")) {
                errorMailSweeper.setOutputFileName(stringArray[i + 1]);
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-i")) {
                errorMailSweeper.addIgnoreAddress(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].equals("--delete")) continue;
            errorMailSweeper.deleteLater(true);
        }
        if (!bl || !bl2) {
            ErrorMailSweeper.printUsage();
        }
        System.out.println("\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
        System.out.println("\u51e6\u7406\u4e2d\u3067\u3059\u30fb\u30fb\u30fb");
        errorMailSweeper.execute();
        System.out.println("\u7d42\u308f\u308a\u307e\u3057\u305f\u3002");
    }
}

