// -*- c++ -*- 
/*****************************************************************************
 * class: Image
 *****************************************************************************/
#ifndef IMAGE_H
#define IMAGE_H

#include <gtk/gtk.h>
#include <gdk_imlib.h>

#include "TshObj.h"

class Pop;

class Image : public TshWgt
{
private:
  bool       M;        // Mode: true.root window false.canvas
  GtkWidget* W[4];     // 0.FullScreen 1.Image 2.Drawing_Area 3.Pen Select
  GdkImlibImage* I;    // Imlib Image
  static GdkPixmap* P; // Pixmap
  GdkBitmap* B;        // Mask
  Pop*       Pm;       // Pop Menu
  int X,Y;             // X.Width, Y.Height
  void setXY();
  void init();

  static GdkGC* G;         // for draw()
  static GdkRectangle R;   // for draw()
  static GdkWindow* Gw;    // for draw()
  static char* C[8];       // Color Strings
  static GdkCursor* Cr[8]; // at draw()

public:
  Image();
  ~Image();
  void load(char*, int);
  void clear();
  void clearWPB();
  void adjust();
  void adjustScreen();
  void rotate();
  void resize();
  void setMode(bool);
  void hideRoot();
  static void press(GtkWidget*, GdkEventButton*, Image*);
  static void press2(GtkWidget*, GdkEventButton*, Image*);
  static void motion(GtkWidget*, GdkEventMotion*, Image*);
  static gint expose(GtkWidget*, GdkEventExpose*, Image*);
  static void draw(GtkWidget*, gdouble, gdouble);
  void popUp(GdkEventButton*);
  void newPop();

  void pen(GdkEventButton*);
  void penMenu();
  static void setPenPoint(int, int);
  void setPenWidth(int);
  static void popFunc(GtkWidget*, char*);
};
#endif
