#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/dir.h>

#include <gdk_imlib.h>

#include "TreeSh.h"
#include "Icon.h"
#include "Util.h"

/*
 * Icon: Constructor/Destructor
 */
Icon::Icon(char* _N, GtkWidget* _W, char* _D)
{
  init();
  N = strdup(_N);

  sprintf(P, "%s/%s.xpm", _D, _N);
  if(!(X[0] = gdk_pixmap_create_from_xpm(_W->window, &B[0], &_W->style->bg[GTK_STATE_NORMAL], P)))
    Util::die("Failure to create Icon", _N);
}

Icon::~Icon()
{
  if(N) delete [] N;
  init();
}

void Icon::init()
{
  N = NULL, X[0] = NULL, X[1] = NULL, B[0] = NULL, B[1] = NULL;
}

/*
 * Icon: Public Members
 */
bool Icon::match(char* _N)
{
  if(!strcmp(_N, N)) return true;
  return false;
}

GdkPixmap* Icon::getXpm(int _i)
{
  if(_i > 1) return NULL;
  if(!X[_i]) return X[0];
  return X[_i];
}

GdkBitmap* Icon::getBmp(int _i)
{
  if(_i > 1) return NULL;
  if(!B[_i]) return B[0];
  return B[_i];
}

void Icon::load(char* _F)
{
  GdkImlibImage* i;
  GdkImlibColorModifier mod;

  if(_F) i = gdk_imlib_load_image(_F);
  else   i = gdk_imlib_load_image(P);

  gdk_imlib_get_image_modifier(i,&mod);
  mod.brightness = 420;
  gdk_imlib_set_image_modifier(i,&mod);
  gdk_imlib_render(i, 16, 16);

  B[1] = gdk_imlib_copy_mask(i);
  X[1] = gdk_imlib_move_image(i);
  
  gdk_imlib_destroy_image(i);
  i = NULL;  
}

/*
 * IcnMgr: Constructor/Destructor
 */
IcnMgr::IcnMgr() : TshObj(Tsh)
{
  char p[256];

  init();
  sprintf(p, "%s/Pixmaps", Tsh->getD());
  addAll(p);

  if(!(D = getIcon("Default"))) Util::die("Cannot get Default Icon", "");
}

IcnMgr::~IcnMgr()
{
  if(I){
    for(int i=0; i<g_list_length(I); i++)
      delete ((Icon*)g_list_nth_data(I, i));
    g_list_free(I);
  }
  init();
}
void IcnMgr::init() { I = NULL, D = NULL; }

/*
 * IcnMgr: Public Members
 */
void IcnMgr::add(char* _N, char* _D)
{
  I = g_list_append(I, new Icon(_N, Tsh->getW(), _D));
}
void IcnMgr::addAll(char* _D)
{
  DIR* d;
  struct direct* dt;
  char* s;

  if(!(d = opendir(_D))) Util::die("Cannot Open Pixmap Directory", _D);

  while((dt = readdir(d)) != NULL) {
    if(dt->d_ino == 0 || strcmp(strchr(dt->d_name, '.'), ".xpm"))
      continue;
    s = dt->d_name;
    s = strtok(s, ".");
    add(s, _D);
  }
    
  closedir(d);
}

Icon* IcnMgr::getIcon(char* _N)
{
  Icon* icn;

  for(int i=0; i<g_list_length(I); i++){
    icn = (Icon*)g_list_nth_data(I, i);
    if(icn->match(_N))
      return icn;
  }
    
  return D;
}

Icon* IcnMgr::getDefault() { return D; }
