// -*- c++ -*- 
/*****************************************************************************
 * class RowData
 *****************************************************************************/
#ifndef ROWDATA_H
#define ROWDATA_H

#include <gtk/gtk.h>

#include "TshObj.h"

class Type;
class Icon;
class Cmd;

class RowData : public TshObj
{
private:
  bool   S;        // Initial Flg
  GList* A;        // Node Info
  Type*  T;        // Node Type      ... Ref
  GtkCTreeNode* R; // CTree Node     ... Ref 
  void init();
  void clearA();

public:
  RowData(Type*, GtkCTreeNode*, GList*);
  RowData(RowData*, GtkCTreeNode*);
  ~RowData();
  char* getLabel();
  GList* getA();
  void  setA(GList*);
  char* getSA(int);
  void  append(char*);
  char* getS(int);
  Cmd*  getCmd(int);
  Type* getType();
  bool  check();
  void  popUp(GdkEventButton*);
  Icon* getIcon();
  GtkCTreeNode* getR();
  bool  getStatus();
  void  setStatus(bool);
  bool  edit(int);

  // test
  void print();
  void clist();
};
#endif
