#include "Color.h"

GdkColor Color::C;
GdkColormap* Color::M;

/*
 * Color: Constructr/Destructor
 */
//Color::Color() {}
//Color::~Color() {}

/*
 * public Member
 */
void Color::init() { M = gdk_colormap_get_system(); }

void Color::set(GdkGC* _G)
{
  gdk_color_alloc(M, &C);
  gdk_gc_set_foreground(_G, &C);
}

void Color::clear(int _P) { C.red = C.green = C.blue = (guint16)(_P*65535.0); }

void Color::white(GdkGC* _G)
{
  clear(255);
  set(_G);
}
void Color::black(GdkGC* _G)
{
  clear(0);
  set(_G);
}

void Color::red(GdkGC* _G)
{
  clear(0);
  C.red = (guint16)(255*65535.0);
  set(_G);
}
void Color::green(GdkGC* _G)
{
  clear(0);
  C.green = (guint16)(255*65535.0);
  set(_G);
}
void Color::blue(GdkGC* _G)
{
  clear(0);
  C.blue = (guint16)(255*65535.0);
  set(_G);
}

void Color::cyan(GdkGC* _G)
{
  clear(0);
  C.green = (guint16)(255*65535.0);
  C.blue = (guint16)(255*65535.0);
  set(_G);
}
void Color::magenta(GdkGC* _G)
{
  clear(0);
  C.blue = (guint16)(255*65535.0);
  C.red = (guint16)(255*65535.0);
  set(_G);
}
void Color::yellow(GdkGC* _G)
{
  clear(0);
  C.red = (guint16)(255*65535.0);
  C.green = (guint16)(255*65535.0);
  set(_G);
}
