// -*- c++ -*- 
/*****************************************************************************
 * class: CList
 *****************************************************************************/
#ifndef CLIST_H
#define CLIST_H

#include <gtk/gtk.h>

#include "TshObj.h"
#include "RowData.h"
#include "Pop.h"

class Pop;

class CList : public TshWgt
{
private:
  bool       T;  // Tumb Flag
  GtkWidget* C;  // CList Widget Ref
  Pop*       Pm; // Pop Menu
  RowData*   Rd; // Ref

public:
  static void select(GtkCList*, gint, gint, GdkEvent*, CList*);
  static void press(GtkWidget*, GdkEventButton*, CList*);

public:
  CList(char*);
  ~CList(){};
  GtkWidget* create(char*);
  GtkWidget* create(GtkCTreeNode*);
  void renew(GtkCTreeNode*);
  void append(GtkCTreeNode*);
  void append(char*);
  void clear();
  void justify();
  void autoResize();
  void setEvents();
  void thumb();
  void thumbLoad(int);
  void thumbMode();
  void normalMode();
  void pop(GdkEventButton*);
  void newPop();
};

class CLMgr : public TshWgt
{
private:
  CList* L;    // Active CList

public:
  CLMgr();
  ~CLMgr(){};

  void renew(GtkCTreeNode*);
  void autoResize();
  void clear();
  void set(CList*);
  GtkWidget* getPp();
  void show();
  void hide();
  void append(GtkCTreeNode*);
  void append(char*);
  void thumb();
};
#endif
