// -*- c++ -*- 
/*****************************************************************************
 * class: Canvas
 *****************************************************************************/
#ifndef CANVAS_H
#define CANVAS_H

#include <gtk/gtk.h>

#include "TshObj.h"
#include "RowData.h"

class CList;
class CLMgr;
class Text;
class Image;
class Form;
class FMgr;

class Canvas : public TshWgt
{
private:
  static CLMgr* Cm; // new
  Text*  T;  // new
  Image* I;  // new
  FMgr*  F;  // new

public:
  Canvas();
  ~Canvas(){};
  void hideAll();

  void clistRenew(GtkCTreeNode*);
  void clistClear();
  void clistAutoResize();
  void clistShow();
  void clistHide();
  void clistSet(CList*, bool);
  void clistAppend(GtkCTreeNode*);
  void clistAppend(char*);
  static void clistThumb();
  GtkWidget* getPpC();

  void textShow();
  void textHide();
  void textInsert(char*);
  void textClear();
  GtkWidget* getPpT();

  void imageShow();
  void imageHide();
  void imageLoad(char*, int);
  void imageCanvas();
  void imageFullScreen();
  GtkWidget* getPpI();

  void formShow();
  void formHide();
  void formSet(Form*, bool);
  GtkWidget* getPpF();
};
#endif
