/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *   ADSP-BF53x UART ʰSIOɥ饤
 *
 *   ΥեϡTOPPERS/JSP 1.4.2 pdic/simple_sio/st16c2550.c
 *   ͡षμ̻ҤѹΤǤ롣
 */
#include <s_services.h>
#include "uart.h"

/*
 * 8250, 16450, 16550ƥ쥸Υɥ쥹եåȡUART_RHRȤ롣
 * ƥऴȤ˰ۤʤΤUART_BOUNDARYˤäƥ쥸ֶꤹ롣
 * ȤФ٤ƤΥ쥸8ӥåȶ֤Ƥʤ顢UART_BOUNDARY1,
 * 16bitʤ2, 32ӥåȶʤ4ꤹ롣
 * UART_BOUNDARYsys_config.h롣
 */


#define UART_RBR   (0x00 * UART_BOUNDARY)   /*  Хåե쥸  */
#define UART_THR   (0x00 * UART_BOUNDARY)   /*  ǡۡɡ쥸 */
#define UART_DLL   (0x00 * UART_BOUNDARY)   /*  ʬ쥸̥Х       */
#define UART_IER   (0x01 * UART_BOUNDARY)   /*  ߥ֥͡쥸       */
#define UART_DLM   (0x01 * UART_BOUNDARY)   /*  ʬ쥸̥Х       */
#define UART_IIR   (0x02 * UART_BOUNDARY)   /*  ߼̥쥸  */
#define UART_FCR   (0x02 * UART_BOUNDARY)   /*  FIFO쥸  */
#define UART_LCR   (0x03 * UART_BOUNDARY)   /*  饤쥸 */
#define UART_MCR   (0x04 * UART_BOUNDARY)   /*  ǥ쥸 */
#define UART_LSR   (0x05 * UART_BOUNDARY)   /*  饤󡦥ơ쥸 */
#define UART_MSR   (0x06 * UART_BOUNDARY)   /*  ǥࡦơ쥸 */
#define UART_SCR   (0x07 * UART_BOUNDARY)   /*  åѥåɡ쥸 */
#define UART_GCTL  (0x09 * UART_BOUNDARY)	  /*  BlackfinΤߡХ쥸 */

/*
 * 쥸Υӥåȥޥü쵡ǽɲäʤ¤ꡢ񤭴ʤƤ褤
 */

#define ISR_TX            0x02       /* ȯ */
#define IER_TX            0x02       /* ߵ */
#define ISR_RX            0x01       /* ȯ */
#define IER_RX            0x01       /* ߵ */

#define LCR_DL_MODE       0x80       /* Divisor Enable */
#define LCR_NP_8_1        0x03       /* 8bit,1stop,Noparity,No break */
#define FCR_FIFO_DISABLE  0x00

#define LSR_RX_DATA_READY 0x01
#define LSR_TX_EMPTY      0x20

#define MCR_INT_ENABLE    0x08

#define GCTL_UCEN		  0x01		/* BlackfinΤ */


/*
 * TNUM_SIOP_UART, UART0_ADDRESS, UART0_DIVISOR sys_config.h롣
 *	TNUM_SIOP_UART : PDICUARTθĿ
 *  ʲPDICǽUARTξ
 *  	UART0_ADDRESS : 		THRΥɥ쥹
 *  	UART0_DIVISOR : 		DLM, DLLν(16bitɽ)
 *      UART0_14550_FIFO : 		14550ߴFIFOĤȤ˥ޥ
 *		UART0_BLACKFIN_UCEN : 	BlackfinѡޥȽɤUART_GCTLUCEN1ˤ롣
 *	ܰʹߤUARTʤʲΤ褦³롣
 *  	UART1_ADDRESS : 		THRΥɥ쥹
 *  	UART1_DIVISOR : 		DLM, DLLν(16bitɽ)
 *      UART1_14550_FIFO : 		14550ߴFIFOĤȤ˥ޥ
 *		UART1_BLACKFIN_UCEN : 	BlackfinѡޥȽɤUART_GCTLUCEN1ˤ롣
 *	...
 */


/******************************************************************************************
 * ꥢI/OݡȽ֥å
 */
#if TNUM_SIOP_UART == 0 
#error "If you don't use UART, please remove this file from your make file" 
#endif

#if TNUM_SIOP_UART > 3
#error "Only TNUM_SIOP_UART < 4 is supported" 
#endif /* TNUM_SIOP_UART >= 2 */    

/* ǥХ׻ޥ */
#define DLM(divisor) (divisor/256)
#define DLL(divisor) (divisor%256)

SIOPINIB siopinib_table[TNUM_SIOP_UART] = {
/*-----------------------------------------------------------------
 *			PDICǽUARTνѥ᡼ 
 */
    {UART0_ADDRESS,  DLM(UART0_DIVISOR), DLL(UART0_DIVISOR),
#ifdef UART0_BLACKFIN_UCEN
		1	/* ޥUART0_BLACKFIN_UCENƤ顢GCTLUCEN1ˤƥåư */
#else
		0
#endif
	}

/*-----------------------------------------------------------------
 *			PDIC2ܤUARTνѥ᡼ 
 */

#if TNUM_SIOP_UART > 1
    ,{UART1_ADDRESS,    DLM(UART1_DIVISOR), DLL(UART1_DIVISOR),
#ifdef UART1_BLACKFIN_UCEN
		1	/* ޥUART1_BLACKFIN_UCENƤ顢GCTLUCEN1ˤƥåư */
#else
		0
#endif


	}
#endif /* if TNUM_SIOP_UART > 1*/

/*-----------------------------------------------------------------
 *			PDIC3ܤUARTνѥ᡼ 
 */
#if TNUM_SIOP_UART > 2
    ,{UART2_ADDRESS,    DLM(UART2_DIVISOR), DLL(UART2_DIVISOR),
#ifdef UART2_BLACKFIN_UCEN
		1	/* ޥUART2_BLACKFIN_UCENƤ顢GCTLUCEN1ˤƥåư */
#else
		0
#endif


	}
#endif /* if TNUM_SIOP_UART > 2*/

};

/*
 * ꥢI/OݡȽ֥åޤǡ
 ******************************************************************************************/



/*
 *  ꥢI/OݡȽ֥åμФ
 */
#define INDEX_SIOPINIB(siopid)  ((UINT)((siopid) - 1))
#define get_siopinib(siopid)  (&(siopinib_table[INDEX_SIOPINIB(siopid)]))


/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
SIOPCB  siopcb_table[TNUM_SIOP_UART];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))

Inline void
uart_write(UW addr, UW offset, UB val)
{
#ifdef UART_IOP_ACCESS
    sil_wrb_iop((VP)(addr + offset),val);
#else
    sil_wrb_mem((VP)(addr + offset),val);	
#endif
}

Inline UB
uart_read(UW addr, UW offset)
{
#ifdef UART_IOP_ACCESS
    return(sil_reb_iop((VP)(addr + offset)));
#else
    return(sil_reb_mem((VP)(addr + offset)));
#endif
}


/*
 * ʸ?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    UH status;

    status = uart_read(siopcb->siopinib->reg_base, UART_LSR);
    
    return((status & LSR_RX_DATA_READY));
}

/*
 * ʸǤ뤫?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
    UH status;

    status = uart_read(siopcb->siopinib->reg_base, UART_LSR);
    
    return (status & LSR_TX_EMPTY);
}

/*
 *  ʸμФ
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return(uart_read(siopcb->siopinib->reg_base,UART_RBR));
}

/*
 *  ʸν񤭹
 */
Inline void
uart_putchar(SIOPCB *siopcb, UB c)
{
    uart_write(siopcb->siopinib->reg_base, UART_THR, c);
}

/*
 *  ߵ
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base,UART_IER) | IER_TX));
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base, UART_IER) & ~IER_TX));
                
}

/*
 *  ߵ
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base,UART_IER) | IER_RX));
}

/*
 *  ߶ػ
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
    uart_write(siopcb->siopinib->reg_base, UART_IER,
                (uart_read(siopcb->siopinib->reg_base, UART_IER) & ~IER_RX));
                
}


/*
 *  SIOɥ饤Фν롼
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  ꥢI/Oݡȴ֥åν
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP_UART; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

    
/*
 *
 */
void
uart_init_siopinib(const SIOPINIB *siopinib)
{

	/*
	 *  Blackfin ADSP-BF531/2/3, BF534/6/7, BF561¢UART˸ͭκȡ
	 *  Power Down⡼ɤβ
	 */
	if ( siopinib->set_ucen )
		uart_write(siopinib->reg_base, UART_GCTL, 
			   (uart_read(siopinib->reg_base, UART_GCTL) | GCTL_UCEN ));
    /*
     *  ʬ
     */
    /* Divisor Enable */
    uart_write(siopinib->reg_base, UART_LCR,
                (uart_read(siopinib->reg_base, UART_LCR) | LCR_DL_MODE));
    uart_write(siopinib->reg_base, UART_DLL, siopinib->dll_val);
    uart_write(siopinib->reg_base, UART_DLM, siopinib->dlm_val);
    /* Divisor Disable */
    uart_write(siopinib->reg_base, UART_LCR,
                (uart_read(siopinib->reg_base, UART_LCR) & ~LCR_DL_MODE));

    /* ⡼, ѥƥ̵ 8bit data, 1 stop bit */
    uart_write(siopinib->reg_base, UART_LCR, LCR_NP_8_1);

    /* ߶ػ */
    uart_write(siopinib->reg_base, UART_IER, 0x00);
}


/*
 *  ͥ뵯ưΥХʡѤν
 */
void 
uart_init(void)
{
    int i;
	/*
	 * ٤Ƥuart롣id 1TNUM_SIOP_UARTޤǡ
	 */
	for ( i=1; i<=TNUM_SIOP_UART; i++ )
	    uart_init_siopinib(get_siopinib(i));
}

/*
 * ץ󤷤ƤݡȤ뤫
 */
BOOL
uart_openflag(void)
{
	int i;
	
	/*
	 * ƤݡȤ0֤ʤ0֤
	 */
	for ( i=0; i<TNUM_SIOP_UART; i++ )
		if (siopcb_table[0].openflag)
			return( 1 );
	return( 0 );
}


/*
 * ꥢI/OݡȤΥץ
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;
    
    /*
     * 
     */
    uart_init_siopinib(siopcb->siopinib);
    
    /* ߵ */
    uart_write(siopcb->siopinib->reg_base, UART_IER, IER_RX);
    
    /* 򥤥֥͡ */
    uart_write(siopcb->siopinib->reg_base, UART_MCR, MCR_INT_ENABLE);

    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    /* ߶ػ */
    uart_write(siopcb->siopinib->reg_base, UART_IER, 0x00);   
    siopcb->openflag = FALSE;
}


/*
 *  ꥢI/OݡȤؤΥݡ󥰤Ǥν
 */
void
uart_pol_putc(char c, ID siopid)
{
    const SIOPINIB *siopinib;
    
    siopinib = get_siopinib(siopid);
    
    while((uart_read(siopinib->reg_base, UART_LSR) & LSR_TX_EMPTY)
          != LSR_TX_EMPTY)
        ;
    uart_write(siopinib->reg_base, UART_THR, c);
}


/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}





/*
 *  ꥢI/OݡȤΥХåε
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{

    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}

/*
 *  ꥢI/OݡȤФ߽
 */
static void
uart_rx_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  ΥХå롼ƤӽФ
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
}

static void
uart_tx_isr_siop(SIOPCB *siopcb)
{
    if (uart_putready(siopcb)) {
        /*
         *  ǽХå롼ƤӽФ
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}

/*
 *  SIOγߥӥ롼
 *	ADSP-BF533¢UART̡γ׵Фᡢ
 *  ISRʬƤ롣ޤADSP-BF537Τ褦İʾ
 *  UARTľθơuart0Τ褦˥ݡֹ
 *  ̾˥ϡɥɤƤ롣
 *  ΥݡֹȤϡSIOΥݡֹǤäơ
 *  ϡɥUARTֹƱȤϸ¤ʤ
 */

/*
 ***** UART0
 */
void
uart0_rx_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[0]));
}

void
uart0_tx_isr()
{
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[0]));
}

/*
 ***** UART1
 */
void
uart1_rx_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[1]));
}

void
uart1_tx_isr()
{
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[1]));
}

/*
 ***** UART2
 */
void
uart2_rx_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[2]));
}

void
uart2_tx_isr()
{
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[2]));
}





/*
 * UARTǳߤͭʤΤۤŪˤϡ
 * Υ롼ǤϤʤߥӥ롼ȤƻȤ
 */
void
uart0_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[0]));
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[0]));
}

void
uart1_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[1]));
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[1]));
}

void
uart2_isr()
{
		/* ̤μƤ */
    uart_rx_isr_siop(&(siopcb_table[2]));
		/* ̤Ƥ */
    uart_tx_isr_siop(&(siopcb_table[2]));
}
