/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */


/*
 *	ץå¸⥸塼 ֥BLACKfinѡ
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 */

			// 32bit 쥸¨ͤɤޥ
#ifdef __GNUC__
#define LOADLABEL( reg, value32 ) reg##.h = value32; reg##.l = value32;
#define LOADVALUE( reg, value32 ) reg##.h = ( value32 >> 16 ) &0xFFFF; reg##.l = value32 & 0xFFFF;
#elif defined(__ECC__)
#define LOADVALUE( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);
#define LOADLABEL LOADVALUE
#else
#error "Compiler is not supported"
#endif



#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ǥѥå
 *
 *  dispatch ϡ߶ػ߾֤ǸƤӽФʤФʤ
 *  exit_and_dispatch ⡤߶ػ߾֤ǸƤӽФ
 *  p0 : &runtsk
 *  p1 : &schedtsk
 *  p2 : runtsk
 *  p3 : schedtsk
 *  p4 : &reqflg
 */
#ifdef __GNUC__
.section .text;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.global _dispatch;
.global _exit_and_dispatch;
.extern ldf_stack_end;
.extern _reqflg;
.extern _call_texrtn;
.extern _runtsk, _schedtsk;
#ifdef __GNUC__
.type _dispatch, STT_FUNC;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif
_dispatch:
	[--sp] = (r7:4, p5:3);
	[--sp] = rets;
	[--sp] = fp;
	LOADLABEL( p0,  _runtsk )
	LOADLABEL( p1,  _schedtsk)
	p2 = [p0];					// p2  runtsk  
	[p2+TCB_sp] = sp;			// å¸
	LOADLABEL( r1, dispatch_r )	// ¹ԺƳϤ¸
	[p2+TCB_pc] = r1;
			// 塼뤵줿Ф
dispatcher:
	r0 = [p1];
	[p0] = r0;					// runtsk = schedtsk
	cc = r0;
	if !cc jump dispatcher_1;	// runtsk̵гԤˡ
	p3 = r0;					// p3schedtsk
	sp = [p3+TCB_sp];			// å
	p5 = [p3+TCB_pc];			// ¹ԺƳ
	jump (p5);					// ¹ԺƳϤ
	
			// ready ʤγԤ
dispatcher_1:
	LOADLABEL( r0, ldf_stack_end)	// ٥ȥåݥ󥿤
	sp = r0;
	LOADLABEL( p4, _reqflg )
wait_for_intr:
	csync;
	raise 14;					// Ԥ֤˰ܹ
	csync;
	/*
	 *  ԤIVG14γ߾֤ǹԤIVG14ܤΤ
	 *  ɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤ2Ĥΰ̣롥
	 *
	 *  ߤԤĴ֤ϡruntsk  NULL=0ˤꤷʤФʤ
	 *  ʤΤ褦ꤷʤȡߥϥɥ餫 iget_tid 
	 *  ƤӽФݤưͤ˹פʤʤ롥
	 *
	 *  Ԥ֤idleˤʤ뤿ᡢºݤˤϳߤǤϤʤwakeup
	 *  ٥Ȥª졢ȼߤ뤳Ȥˤʤ롣
	 *  äƳԤ򤪤ʤˤϡбSIC_IWRΥӥåȤ
    *  1ˤƤʤФʤʤ
	 *  ϥץꥱץޤǤǹԤ
	 */
	r0 = [p4];					// reqflag
	cc = r0;
	if !cc jump wait_for_intr;	// reqflg0ʤԤ
	r0 = 0;
	[p4] = r0;					// reqflg򥯥ꥢ
	jump dispatcher;


			// κƳϡ㳰ν򤪤ʤ
			// dispatch()
			// Υɥ쥹ؤɬ dispatcherǤ롣
			// äơp3ɬschedtskƤˤʤäƤ롣
dispatch_r:
	fp = [sp++];
	r2 = [p3+TCB_texptn];		// schedtsk->texptn
	cc = r2 == 0;				// texptrn0ʤcc => 1
//	r0 = [p3+TCB_enatex];
//	LOADVALUE( r1, TCB_enatex_mask )
	r0 = b[p3+TCB_enatex](z);
	r1 = TCB_enatex_mask;
	r0 = r0 & r1;				// enatex0ʤ顢az => 1
	cc |= az;					// cc = ( !enatex || ! texptn ) = !( enatex && texptn )
	if cc jump dispatch_r_1(bp);	// if ( !enatex || !texptn ) ¨꥿
	sp += -12;					// ߡΰ
	call _call_texrtn;
	sp += 12;					// ߡΰ賫
dispatch_r_1:
	rets = [sp++];
	(r7:4, p5:3) = [sp++];
	rts;
_dispatch.end:

#ifdef __GNUC__
.size	_dispatch, .-_dispatch
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif


/*	
 *	TOPPERS/JSPϽ:
 *	 start.asm  kernel_startCPUå̤֡ͥǸƤ֡
 *	 kernel_startϤΤޤexit_and_dispatchƤ֡
 *	 _exit_and_dispatchϡޤǤΥå֤ʤɤñѴ
 *	 塼뤵줿򳫻Ϥ롣
*/
_exit_and_dispatch:
		// dispatcherʹߤǻȤݥ󥿤
	LOADLABEL( p0,  _runtsk )
	LOADLABEL( p1,  _schedtsk)
	jump dispatcher;
_exit_and_dispatch.end:

/*
 *  ư
 *  _activate_rؤϤʤ餺dispatcherǤ롣ΤᡢCPUå
 * ϤʤФʤʤ
 */

	.global _activate_r;
_activate_r:
	r1 = 0xffff(z);
    cli r0;         // ߤΥޥФ
                        // ߤȤʤȤˤ⡢߶ػߤΤcliɬ
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ߤΤ߼Ф
	r2 = ~r2;					// եޥ
	r1 = r1 & r2;				// 
	r1 = r1 | r0;				// ߤθޥ
#endif
	sti r1;				// CPU å
	p0 = [sp++];		// ȥ꡼Ф
	r0 = [sp++];		// ext_tskϤФ
	rets = r0;			// ext_tskߡϤˤ
	r0 = [sp++];		// ext_infФ : r0 ϰ1
	sp += -12;
	jump (p0);			// γ
_activate_r.end:


/*
*	߽Υȥ
*
*	interrupt_handlerؤivgXXEntry饸פƤ롣p0쥸ˤ
*	ߥ٥ֹ椬ǼƤ롣
*	ߤȤΥͥȴطĴ١ͥȤƤʤʤ饤٥ȥå򥻥åȤ롣
*		p2 : reqflgΥɥ쥹
*		r6 : å
*		r7 : ASTAT
*
*/

#include "saverestore.h"

.global interrupt_dispatcher;
.global task_context;
.extern _device_dispatcher, _enadsp;

#ifdef __GNUC__
.type interrupt_dispatcher, STT_FUNC;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif
interrupt_dispatcher:
				// save all task context register
	save_regs;					// 桼쥸
	r0 = 0;
	l0 = r0;
	l1 = r0;
	l2 = r0;
	l3 = r0;
	lc0 = r0;					// ǽ㲼ΤLCx򥯥ꥢ
	lc1 = r0;
	LOADVALUE( p1, IPEND )			// IPEND쥸Υɥ쥹
	r0 = [p1];					// IPENDͤ
	r1 = 0x7fef;				// 
	r0 = r0 & r1;				// IVG15GIDʳĴ٤
	r0.L = ones r0;				// Υ٥Ȥο
	r0 += -1;					// ٥Ȥο-1ͥȤƤʤ0ˤʤ롣
	cc = az;					// ͥȤƤʤп
	if !cc jump call_interrupt;	// ⤷ͥȤƤХϥɥƤ
								// ͥȤƤʤߤʤ顢åڤؤ
	r6 = sp;					// åݥ󥿤
	LOADLABEL( r0, ldf_stack_end)	// ٥ȥåݥ󥿤
	sp = r0;
	
call_interrupt:
	[--sp] = reti;				// ǳ߲ǽˤʤ
	r7 = astat;					// ccˤϥͥȾäƤ롣
	r0 = p0;					// ߽
	LOADLABEL( p0, _device_dispatcher)
	sp += -12;					// ߡ (A)
	call	(p0);				// Cǽ񤫤줿ǥХǥѥåƤ
	sp += 12;					// ߡ (A)
	astat = r7;					// cc
	reti = [sp++];				// ǺƤӳ߶ػ
	if !cc jump get_back;		// ⤷ͥȤƤʤСΤޤ޵
	
								// ǤϳߤϥͥȤƤʤ
	sp = r6;					// å򥿥å

	LOADLABEL( p2, _reqflg)			// reqflgΥɥ쥹
	r0 = [p2];					// reqflgͤ
	cc = r0;					// ǥѥå㳰׵ϽФƤ뤫
	if !cc jump get_back(bp);	// ФƤʤʤгޤ줿

								// ƥڤؤȳ
	r0 = 0;						// 
	[p2] = r0;					// reqflg򥯥ꥢ.
	r0 = reti;					// ϤФ
	r1 = 1;
	r0 = r1 | r0; 				// աͥȤǤȵ
	[--sp] = r0;				// Ϥ򥹥åˤĤ
	LOADLABEL( p0, task_context)
	
	cli r0;						// ߤCPUå֤
	[--sp] = r0;				// å֤
	
	r1 = 0xC01F(z);				// ƥȤϤCPUå֤Ǽ¹Ԥ
#ifdef UNMANAGED_INT
    r2 = UNMANAGED_INT(z);
    r0 = r0 & r2;				// ߤΥޥ֤
    r1 = r0 | r1;				// ƥȤCPUå֤Ǽ¹Ԥ
#endif
	sti r1;						// CPUå (B)
	
	reti = p0;					// ٥"task_context"ߤϤˤ
	rti;						// ߤ롣ƥȤϥˤʤ
	csync;
task_context:					// ϥƥȤǡCPUå֤Ǥ
	LOADLABEL( p0, _enadsp)
	LOADLABEL( p1, _runtsk)

	
	r2 = [p0];					// load enadsp
	cc = r2;					// ǥѥåǽ
	if !cc jump go_tex;			// ⤷ǥѥåػߤʤ㳰å
	
	LOADLABEL( p0, _schedtsk)		// ǥѥåǽξ
	r1 = [p1];					// runtsk
	r0 = [p0];					// schedtsk
	cc = r0 == r1;				// schedtsk == runtsk
	if cc jump go_tex(bp);		// ⤷ schedtsk == runtskʤС㳰˹Ԥ
								// ǤʤХǥѥå
	sp += -12;					// ߡΰ (C)	
	call _dispatch;				// åĥ
	sp += 12;					// ߡΰ賫 (C)
	jump return_as_task;		// 
	
go_tex:
	p1 = [p1];					// runtsk
	r0 = [p1 + TCB_texptn];		// runtsk->texptrn ( UINT )
	cc = r0 == 0;				// texptn0ʤ1
//	r0 = [p1 + TCB_enatex];		// runtsk->enatex
//	LOADVALUE( r1, TCB_enatex_mask)
	r0 = b[p1 + TCB_enatex](z);		// runtsk->enatex
	r1 = TCB_enatex_mask;
	r1 = r0 & r1;				// 㳰ĤƤʤ1
	cc |= az;					// 㳰ĤƤʤtexptn0ʤ¨
	if cc jump return_as_task(bp);	// ĤƤʤХ
	sp += -12;					// ߡΰ (D)	
	call _call_texrtn;			// 郎äΤǥ㳰Ԥ
	sp += 12;					// ߡΰ賫 (D)
	
return_as_task:					// ƥȾ֤Ǥ
	r0 = [sp++];				// 򤷤Ƥå
	reti = [sp++];				// Ϥʸrtiޤǳ߶ػ
    cli r1;               // ߤΥå֤Ф
                                // ߤȤʤ⤳cliݸΤɬ
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r1 = r1 & r2;				// ¹Υޥߤξ֤
	r2 = ~ r2;					// UNMANAGED_INTεեޥ
	r0 = r0 & r2;				// Υå֤ߥޥ򥯥ꥢ
	r0 = r0 | r1;				// 򤷤Ƥå֤򥢥åץǡ
#endif
	sti r0;						// CPUå(B)(F)
	
	
get_back:						// 󥿥ƥȾ֤Ǥ
	restore_regs;				// 򤷤쥸᤹
	p0=[sp++];
	rti;						// 

interrupt_dispatcher.end:

#ifdef __GNUC__
.size	interrupt_dispatcher, .-interrupt_dispatcher
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif




/*
 *  Ԥ
 *  ¦Υ롼פ12ǲ롣
 */
	.global _sil_dly_nse;
_sil_dly_nse:
	r1 = SIL_DLY_TIM1;
	r2 = SIL_DLY_TIM2;
	r0 = r0 - r1;			// dilay - SIL_DLY_TIM1
	cc = an;			// ̤0礭
	if !cc jump _sil_dly_nse_1;	// 롼
	rts;
_sil_dly_nse_1:
	r0 = r0 - r2;
	nop;
	cc = an;			// ̤0礭
	if !cc jump _sil_dly_nse_1;	// 롼
	rts;
_sil_dly_nse.end:

