/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  
 */


#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_


/*
 *  ͥ̾Υ͡
 */
#include <sys_rename.h>

/*
* ܡեɤ߹
*/
#include <board_config.h>
 
/*
 *	åȥƥ¸⥸塼EZKIT-BF533ѡ
 *
 *  Υ󥯥롼ɥեϡt_config.h Τߤ饤󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤƤϤʤʤ
*/

/*
 *  åȥƥΥϡɥ񸻤
 * 
 *  DEVICE_INTERRUPT_COUNTSIC_IMASKΥӥåȿ
 *  Ϳ롣
 *  ADSP-BF533Υӥåȿ24ʤΤǡͤ24Ǥ롣
 */

#define DEVICE_INTERRUPT_COUNT 24
 


/*
 *  PLLåȿ
 */
#define PLLCLOCK (CLKIN*MSELVAL)
#define SYSCLOCK  (PLLCLOCK / SSELVAL)
#define CORECLOCK (PLLCLOCK / CSELVAL)



/*
 *  TICγߥϥɥΥ٥ֹ
 */
#ifdef USE_TIC_CORE
#define INHNO_TIMER	INHNO_CORE_TIMER
#else
#define INHNO_TIMER	INHNO_GP_TIMER2
#endif


/*
 *  ԤΤ
 *  sil_dly_nseθƤӽФСإåɤȥ롼ץܥǥ
 *  nSɽؿcpu_support.asmƤ롣
 *  SIL_DLY_TIM124롣32nS( 750MHz ), 40nS( 600MHz )
 *  SIL_DLY_TIM212롣16nS( 750MHz ), 20nS( 600MHz )
 */


#define	SIL_DLY_TIM1	(24*1000000000/CORECLOCK)
#define	SIL_DLY_TIM2	(12*1000000000/CORECLOCK)

/*************************************************************************
 * uart.cѹޥ
 */ 

/*  ꥢγߥϥɥΥ٥ֹ */
#define INHNO_SIO0_TX   INHNO_UART_TX
#define INHNO_SIO0_RX   INHNO_UART_RX

/*
 *  UART쥸ֶADSP-BF533¢UART4Хȼǥ쥸
 *  ¤ǤΤǡˤ4ꤹ롣
 */
#define UART_BOUNDARY 4

/*  UART쥸sil_xxb_iop()ȤäƥȤˤUART_IOP_ACCESS 롣*/
#define UART_IOP_ACCESS 

/*  ꥢݡȤΥɥ쥹 */
#define UART0_ADDRESS 0xFFC00400	// ¢UART THRΥɥ쥹

/*  UARTΥܡ졼ȥͥ졼ꤹ٤͡ */
#define UART0_DIVISOR	SYSCLOCK/16/9600		/* 9600bpsʾ̡*/

/*  ¢UARTȤϡUARTx_BLACKFIN_UCENUCENʤФʤʤ*/
#define UART0_BLACKFIN_UCEN


/*
 * uart.cѹޥ
 *************************************************************************/ 



/*
 *  ߥ٥ȥֹ
 *
 *  ϥե졼եDEF_INHΰȤƻȤ
 *  SIC_ISRˤӥåֹǤ롣
 *
 */
#define INHNO_PLL			0
#define INHNO_DMA_ERROR		1
#define INHNO_PPI_ERROR		2
#define INHNO_SPORT0_ERROR	3
#define INHNO_SPORT2_ERROR	4
#define INHNO_SPI_ERROR		5
#define INHNO_UART_ERROR	6
#define INHNO_RTC			7
#define INHNO_PPI			8
#define INHNO_SPORT0_RX		9
#define INHNO_SPORT0_TX		10
#define INHNO_SPORT1_RX		11
#define INHNO_SPORT1_TX		12
#define INHNO_SPI			13
#define INHNO_UART_RX		14
#define INHNO_UART_TX		15
#define INHNO_GP_TIMER0		16
#define INHNO_GP_TIMER1		17
#define INHNO_GP_TIMER2		18
#define INHNO_PFA			19
#define INHNO_PFB			20
#define INHNO_MEMORY_DMA0	21
#define INHNO_MEMORY_DMA1	22
#define INHNO_WDG			23

// SIC_ISRˤʤüʳ
#ifdef USE_HW_ERROR
#define INHNO_HW_ERROR 		24
#endif
#define INHNO_GP_TIMER 		25
#define INHNO_RAISE 		26


/*
 *  SIC_ISRγߤΥ٥ֹ
 *
 *  ena_int, dis_intΰȤƻȤ
 */

#define INTNO_PLL			0
#define INTNO_DMA_ERROR		1
#define INTNO_PPI_ERROR		2
#define INTNO_SPORT0_ERROR	3
#define INTNO_SPORT2_ERROR	4
#define INTNO_SPI_ERROR		5
#define INTNO_UART_ERROR	6
#define INTNO_RTC			7
#define INTNO_PPI			8
#define INTNO_SPORT0_RX		9
#define INTNO_SPORT0_TX		10
#define INTNO_SPORT1_RX		11
#define INTNO_SPORT1_TX		12
#define INTNO_SPI			13
#define INTNO_UART_RX		14
#define INTNO_UART_TX		15
#define INTNO_GP_TIMER0		16
#define INTNO_GP_TIMER1		17
#define INTNO_GP_TIMER2		18
#define INTNO_PFA			19
#define INTNO_PFB			20
#define INTNO_MEMORY_DMA0	21
#define INTNO_MEMORY_DMA1	22
#define INTNO_WDG			23



#ifndef _MACRO_ONLY

/*
* SIC_IARxϤơ٥Ƚ̤Ȥ˳ƤƤ
* Υӥåȥޥåפ롣SIC_IARxΥեͤͥ-7ʤΤ
* ʬ롣
*/
void make_priority_mask( void );

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥GDB STUBƽФǼ¸롥
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥GDB STUBƽФǼ
 *  롥
 */
extern void	sys_putc(char c);

/*
* SIC_IARxϤơ٥Ƚ̤Ȥ˳ƤƤ
* Υӥåȥޥåפ롣SIC_IARxΥեͤͥ-7ʤΤ
* ʬ롣
*/
void make_priority_mask( void );

/*
 * ߤεġػ
 *
 */
typedef unsigned int INTNO; 
extern ER ena_int( INTNO intno );
extern ER dis_int( INTNO intno );

/*
 * ߥޥ
 *
 *
 */
typedef unsigned int IMS;
extern ER chg_ims( IMS ims );
extern ER get_ims( IMS * p_ims );


#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
