/*
 * editpolicy.h
 *
 * TOMOYO Linux's utilities.
 *
 * Copyright (C) 2005-2011  NTT DATA CORPORATION
 *
 * Version: 1.8.3+   2015/04/21
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License v2 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */
#include <signal.h>
#include <curses.h>

enum screen_type {
	SCREEN_EXCEPTION_LIST,
	SCREEN_DOMAIN_LIST,
	SCREEN_ACL_LIST,
	SCREEN_PROFILE_LIST,
	SCREEN_MANAGER_LIST,
	/* SCREEN_QUERY_LIST, */
	SCREEN_NS_LIST,
	SCREEN_STAT_LIST,
	MAX_SCREEN_TYPE
};

enum transition_type {
	/* Do not change this order, */
	TRANSITION_NO_RESET,
	TRANSITION_RESET,
	TRANSITION_NO_INITIALIZE,
	TRANSITION_INITIALIZE,
	TRANSITION_NO_KEEP,
	TRANSITION_KEEP,
	MAX_TRANSITION_TYPE
};

enum directive_type {
	DIRECTIVE_NONE,
	DIRECTIVE_ACL_GROUP_000,
	DIRECTIVE_ACL_GROUP_001,
	DIRECTIVE_ACL_GROUP_002,
	DIRECTIVE_ACL_GROUP_003,
	DIRECTIVE_ACL_GROUP_004,
	DIRECTIVE_ACL_GROUP_005,
	DIRECTIVE_ACL_GROUP_006,
	DIRECTIVE_ACL_GROUP_007,
	DIRECTIVE_ACL_GROUP_008,
	DIRECTIVE_ACL_GROUP_009,
	DIRECTIVE_ACL_GROUP_010,
	DIRECTIVE_ACL_GROUP_011,
	DIRECTIVE_ACL_GROUP_012,
	DIRECTIVE_ACL_GROUP_013,
	DIRECTIVE_ACL_GROUP_014,
	DIRECTIVE_ACL_GROUP_015,
	DIRECTIVE_ACL_GROUP_016,
	DIRECTIVE_ACL_GROUP_017,
	DIRECTIVE_ACL_GROUP_018,
	DIRECTIVE_ACL_GROUP_019,
	DIRECTIVE_ACL_GROUP_020,
	DIRECTIVE_ACL_GROUP_021,
	DIRECTIVE_ACL_GROUP_022,
	DIRECTIVE_ACL_GROUP_023,
	DIRECTIVE_ACL_GROUP_024,
	DIRECTIVE_ACL_GROUP_025,
	DIRECTIVE_ACL_GROUP_026,
	DIRECTIVE_ACL_GROUP_027,
	DIRECTIVE_ACL_GROUP_028,
	DIRECTIVE_ACL_GROUP_029,
	DIRECTIVE_ACL_GROUP_030,
	DIRECTIVE_ACL_GROUP_031,
	DIRECTIVE_ACL_GROUP_032,
	DIRECTIVE_ACL_GROUP_033,
	DIRECTIVE_ACL_GROUP_034,
	DIRECTIVE_ACL_GROUP_035,
	DIRECTIVE_ACL_GROUP_036,
	DIRECTIVE_ACL_GROUP_037,
	DIRECTIVE_ACL_GROUP_038,
	DIRECTIVE_ACL_GROUP_039,
	DIRECTIVE_ACL_GROUP_040,
	DIRECTIVE_ACL_GROUP_041,
	DIRECTIVE_ACL_GROUP_042,
	DIRECTIVE_ACL_GROUP_043,
	DIRECTIVE_ACL_GROUP_044,
	DIRECTIVE_ACL_GROUP_045,
	DIRECTIVE_ACL_GROUP_046,
	DIRECTIVE_ACL_GROUP_047,
	DIRECTIVE_ACL_GROUP_048,
	DIRECTIVE_ACL_GROUP_049,
	DIRECTIVE_ACL_GROUP_050,
	DIRECTIVE_ACL_GROUP_051,
	DIRECTIVE_ACL_GROUP_052,
	DIRECTIVE_ACL_GROUP_053,
	DIRECTIVE_ACL_GROUP_054,
	DIRECTIVE_ACL_GROUP_055,
	DIRECTIVE_ACL_GROUP_056,
	DIRECTIVE_ACL_GROUP_057,
	DIRECTIVE_ACL_GROUP_058,
	DIRECTIVE_ACL_GROUP_059,
	DIRECTIVE_ACL_GROUP_060,
	DIRECTIVE_ACL_GROUP_061,
	DIRECTIVE_ACL_GROUP_062,
	DIRECTIVE_ACL_GROUP_063,
	DIRECTIVE_ACL_GROUP_064,
	DIRECTIVE_ACL_GROUP_065,
	DIRECTIVE_ACL_GROUP_066,
	DIRECTIVE_ACL_GROUP_067,
	DIRECTIVE_ACL_GROUP_068,
	DIRECTIVE_ACL_GROUP_069,
	DIRECTIVE_ACL_GROUP_070,
	DIRECTIVE_ACL_GROUP_071,
	DIRECTIVE_ACL_GROUP_072,
	DIRECTIVE_ACL_GROUP_073,
	DIRECTIVE_ACL_GROUP_074,
	DIRECTIVE_ACL_GROUP_075,
	DIRECTIVE_ACL_GROUP_076,
	DIRECTIVE_ACL_GROUP_077,
	DIRECTIVE_ACL_GROUP_078,
	DIRECTIVE_ACL_GROUP_079,
	DIRECTIVE_ACL_GROUP_080,
	DIRECTIVE_ACL_GROUP_081,
	DIRECTIVE_ACL_GROUP_082,
	DIRECTIVE_ACL_GROUP_083,
	DIRECTIVE_ACL_GROUP_084,
	DIRECTIVE_ACL_GROUP_085,
	DIRECTIVE_ACL_GROUP_086,
	DIRECTIVE_ACL_GROUP_087,
	DIRECTIVE_ACL_GROUP_088,
	DIRECTIVE_ACL_GROUP_089,
	DIRECTIVE_ACL_GROUP_090,
	DIRECTIVE_ACL_GROUP_091,
	DIRECTIVE_ACL_GROUP_092,
	DIRECTIVE_ACL_GROUP_093,
	DIRECTIVE_ACL_GROUP_094,
	DIRECTIVE_ACL_GROUP_095,
	DIRECTIVE_ACL_GROUP_096,
	DIRECTIVE_ACL_GROUP_097,
	DIRECTIVE_ACL_GROUP_098,
	DIRECTIVE_ACL_GROUP_099,
	DIRECTIVE_ACL_GROUP_100,
	DIRECTIVE_ACL_GROUP_101,
	DIRECTIVE_ACL_GROUP_102,
	DIRECTIVE_ACL_GROUP_103,
	DIRECTIVE_ACL_GROUP_104,
	DIRECTIVE_ACL_GROUP_105,
	DIRECTIVE_ACL_GROUP_106,
	DIRECTIVE_ACL_GROUP_107,
	DIRECTIVE_ACL_GROUP_108,
	DIRECTIVE_ACL_GROUP_109,
	DIRECTIVE_ACL_GROUP_110,
	DIRECTIVE_ACL_GROUP_111,
	DIRECTIVE_ACL_GROUP_112,
	DIRECTIVE_ACL_GROUP_113,
	DIRECTIVE_ACL_GROUP_114,
	DIRECTIVE_ACL_GROUP_115,
	DIRECTIVE_ACL_GROUP_116,
	DIRECTIVE_ACL_GROUP_117,
	DIRECTIVE_ACL_GROUP_118,
	DIRECTIVE_ACL_GROUP_119,
	DIRECTIVE_ACL_GROUP_120,
	DIRECTIVE_ACL_GROUP_121,
	DIRECTIVE_ACL_GROUP_122,
	DIRECTIVE_ACL_GROUP_123,
	DIRECTIVE_ACL_GROUP_124,
	DIRECTIVE_ACL_GROUP_125,
	DIRECTIVE_ACL_GROUP_126,
	DIRECTIVE_ACL_GROUP_127,
	DIRECTIVE_ACL_GROUP_128,
	DIRECTIVE_ACL_GROUP_129,
	DIRECTIVE_ACL_GROUP_130,
	DIRECTIVE_ACL_GROUP_131,
	DIRECTIVE_ACL_GROUP_132,
	DIRECTIVE_ACL_GROUP_133,
	DIRECTIVE_ACL_GROUP_134,
	DIRECTIVE_ACL_GROUP_135,
	DIRECTIVE_ACL_GROUP_136,
	DIRECTIVE_ACL_GROUP_137,
	DIRECTIVE_ACL_GROUP_138,
	DIRECTIVE_ACL_GROUP_139,
	DIRECTIVE_ACL_GROUP_140,
	DIRECTIVE_ACL_GROUP_141,
	DIRECTIVE_ACL_GROUP_142,
	DIRECTIVE_ACL_GROUP_143,
	DIRECTIVE_ACL_GROUP_144,
	DIRECTIVE_ACL_GROUP_145,
	DIRECTIVE_ACL_GROUP_146,
	DIRECTIVE_ACL_GROUP_147,
	DIRECTIVE_ACL_GROUP_148,
	DIRECTIVE_ACL_GROUP_149,
	DIRECTIVE_ACL_GROUP_150,
	DIRECTIVE_ACL_GROUP_151,
	DIRECTIVE_ACL_GROUP_152,
	DIRECTIVE_ACL_GROUP_153,
	DIRECTIVE_ACL_GROUP_154,
	DIRECTIVE_ACL_GROUP_155,
	DIRECTIVE_ACL_GROUP_156,
	DIRECTIVE_ACL_GROUP_157,
	DIRECTIVE_ACL_GROUP_158,
	DIRECTIVE_ACL_GROUP_159,
	DIRECTIVE_ACL_GROUP_160,
	DIRECTIVE_ACL_GROUP_161,
	DIRECTIVE_ACL_GROUP_162,
	DIRECTIVE_ACL_GROUP_163,
	DIRECTIVE_ACL_GROUP_164,
	DIRECTIVE_ACL_GROUP_165,
	DIRECTIVE_ACL_GROUP_166,
	DIRECTIVE_ACL_GROUP_167,
	DIRECTIVE_ACL_GROUP_168,
	DIRECTIVE_ACL_GROUP_169,
	DIRECTIVE_ACL_GROUP_170,
	DIRECTIVE_ACL_GROUP_171,
	DIRECTIVE_ACL_GROUP_172,
	DIRECTIVE_ACL_GROUP_173,
	DIRECTIVE_ACL_GROUP_174,
	DIRECTIVE_ACL_GROUP_175,
	DIRECTIVE_ACL_GROUP_176,
	DIRECTIVE_ACL_GROUP_177,
	DIRECTIVE_ACL_GROUP_178,
	DIRECTIVE_ACL_GROUP_179,
	DIRECTIVE_ACL_GROUP_180,
	DIRECTIVE_ACL_GROUP_181,
	DIRECTIVE_ACL_GROUP_182,
	DIRECTIVE_ACL_GROUP_183,
	DIRECTIVE_ACL_GROUP_184,
	DIRECTIVE_ACL_GROUP_185,
	DIRECTIVE_ACL_GROUP_186,
	DIRECTIVE_ACL_GROUP_187,
	DIRECTIVE_ACL_GROUP_188,
	DIRECTIVE_ACL_GROUP_189,
	DIRECTIVE_ACL_GROUP_190,
	DIRECTIVE_ACL_GROUP_191,
	DIRECTIVE_ACL_GROUP_192,
	DIRECTIVE_ACL_GROUP_193,
	DIRECTIVE_ACL_GROUP_194,
	DIRECTIVE_ACL_GROUP_195,
	DIRECTIVE_ACL_GROUP_196,
	DIRECTIVE_ACL_GROUP_197,
	DIRECTIVE_ACL_GROUP_198,
	DIRECTIVE_ACL_GROUP_199,
	DIRECTIVE_ACL_GROUP_200,
	DIRECTIVE_ACL_GROUP_201,
	DIRECTIVE_ACL_GROUP_202,
	DIRECTIVE_ACL_GROUP_203,
	DIRECTIVE_ACL_GROUP_204,
	DIRECTIVE_ACL_GROUP_205,
	DIRECTIVE_ACL_GROUP_206,
	DIRECTIVE_ACL_GROUP_207,
	DIRECTIVE_ACL_GROUP_208,
	DIRECTIVE_ACL_GROUP_209,
	DIRECTIVE_ACL_GROUP_210,
	DIRECTIVE_ACL_GROUP_211,
	DIRECTIVE_ACL_GROUP_212,
	DIRECTIVE_ACL_GROUP_213,
	DIRECTIVE_ACL_GROUP_214,
	DIRECTIVE_ACL_GROUP_215,
	DIRECTIVE_ACL_GROUP_216,
	DIRECTIVE_ACL_GROUP_217,
	DIRECTIVE_ACL_GROUP_218,
	DIRECTIVE_ACL_GROUP_219,
	DIRECTIVE_ACL_GROUP_220,
	DIRECTIVE_ACL_GROUP_221,
	DIRECTIVE_ACL_GROUP_222,
	DIRECTIVE_ACL_GROUP_223,
	DIRECTIVE_ACL_GROUP_224,
	DIRECTIVE_ACL_GROUP_225,
	DIRECTIVE_ACL_GROUP_226,
	DIRECTIVE_ACL_GROUP_227,
	DIRECTIVE_ACL_GROUP_228,
	DIRECTIVE_ACL_GROUP_229,
	DIRECTIVE_ACL_GROUP_230,
	DIRECTIVE_ACL_GROUP_231,
	DIRECTIVE_ACL_GROUP_232,
	DIRECTIVE_ACL_GROUP_233,
	DIRECTIVE_ACL_GROUP_234,
	DIRECTIVE_ACL_GROUP_235,
	DIRECTIVE_ACL_GROUP_236,
	DIRECTIVE_ACL_GROUP_237,
	DIRECTIVE_ACL_GROUP_238,
	DIRECTIVE_ACL_GROUP_239,
	DIRECTIVE_ACL_GROUP_240,
	DIRECTIVE_ACL_GROUP_241,
	DIRECTIVE_ACL_GROUP_242,
	DIRECTIVE_ACL_GROUP_243,
	DIRECTIVE_ACL_GROUP_244,
	DIRECTIVE_ACL_GROUP_245,
	DIRECTIVE_ACL_GROUP_246,
	DIRECTIVE_ACL_GROUP_247,
	DIRECTIVE_ACL_GROUP_248,
	DIRECTIVE_ACL_GROUP_249,
	DIRECTIVE_ACL_GROUP_250,
	DIRECTIVE_ACL_GROUP_251,
	DIRECTIVE_ACL_GROUP_252,
	DIRECTIVE_ACL_GROUP_253,
	DIRECTIVE_ACL_GROUP_254,
	DIRECTIVE_ACL_GROUP_255,
	DIRECTIVE_ADDRESS_GROUP,
	DIRECTIVE_AGGREGATOR,
	DIRECTIVE_CAPABILITY,
	DIRECTIVE_DENY_AUTOBIND,
	DIRECTIVE_FILE_APPEND,
	DIRECTIVE_FILE_CHGRP,
	DIRECTIVE_FILE_CHMOD,
	DIRECTIVE_FILE_CHOWN,
	DIRECTIVE_FILE_CHROOT,
	DIRECTIVE_FILE_CREATE,
	DIRECTIVE_FILE_EXECUTE,
	DIRECTIVE_FILE_GETATTR,
	DIRECTIVE_FILE_IOCTL,
	DIRECTIVE_FILE_LINK,
	DIRECTIVE_FILE_MKBLOCK,
	DIRECTIVE_FILE_MKCHAR,
	DIRECTIVE_FILE_MKDIR,
	DIRECTIVE_FILE_MKFIFO,
	DIRECTIVE_FILE_MKSOCK,
	DIRECTIVE_FILE_MOUNT,
	DIRECTIVE_FILE_PIVOT_ROOT,
	DIRECTIVE_FILE_READ,
	DIRECTIVE_FILE_RENAME,
	DIRECTIVE_FILE_RMDIR,
	DIRECTIVE_FILE_SYMLINK,
	DIRECTIVE_FILE_TRUNCATE,
	DIRECTIVE_FILE_UNLINK,
	DIRECTIVE_FILE_UNMOUNT,
	DIRECTIVE_FILE_WRITE,
	DIRECTIVE_INITIALIZE_DOMAIN,
	DIRECTIVE_IPC_SIGNAL,
	DIRECTIVE_KEEP_DOMAIN,
	DIRECTIVE_MISC_ENV,
	DIRECTIVE_NETWORK_INET,
	DIRECTIVE_NETWORK_UNIX,
	DIRECTIVE_NO_INITIALIZE_DOMAIN,
	DIRECTIVE_NO_KEEP_DOMAIN,
	DIRECTIVE_NO_RESET_DOMAIN,
	DIRECTIVE_NUMBER_GROUP,
	DIRECTIVE_PATH_GROUP,
	DIRECTIVE_QUOTA_EXCEEDED,
	DIRECTIVE_RESET_DOMAIN,
	DIRECTIVE_TASK_AUTO_DOMAIN_TRANSITION,
	DIRECTIVE_TASK_AUTO_EXECUTE_HANDLER,
	DIRECTIVE_TASK_DENIED_EXECUTE_HANDLER,
	DIRECTIVE_TASK_MANUAL_DOMAIN_TRANSITION,
	DIRECTIVE_TRANSITION_FAILED,
	DIRECTIVE_USE_GROUP,
	DIRECTIVE_USE_PROFILE,
	MAX_DIRECTIVE_TYPE
};

enum color_type {
	COLOR_NORMAL,
	COLOR_DOMAIN_HEAD,
	COLOR_DOMAIN_CURSOR,
	COLOR_EXCEPTION_HEAD,
	COLOR_EXCEPTION_CURSOR,
	COLOR_ACL_HEAD,
	COLOR_ACL_CURSOR,
	COLOR_PROFILE_HEAD,
	COLOR_PROFILE_CURSOR,
	COLOR_MANAGER_HEAD,
	COLOR_MANAGER_CURSOR,
	COLOR_STAT_HEAD,
	COLOR_STAT_CURSOR,
	COLOR_DEFAULT_COLOR,
	COLOR_DISP_ERR
};

struct transition_entry {
	const struct ccs_path_info *ns;
	const struct ccs_path_info *domainname;    /* This may be NULL */
	const struct ccs_path_info *program;       /* This may be NULL */
	enum transition_type type;
};

struct transition_preference {
	int index;
	char *program;
	char *domainname;
};

struct generic_entry {
	enum directive_type directive;
	_Bool selected;
	const char *operand;
};

struct editpolicy_directive {
	const char *original;
	const char *alias;
	int original_len;
	int alias_len;
};

struct path_group {
	const struct ccs_path_info *ns;
	const struct ccs_path_info *group_name;
	const struct ccs_path_info **member_name;
	int member_name_len;
};

struct address_group {
	const struct ccs_path_info *group_name;
	struct ccs_ip_address_entry *member_name;
	int member_name_len;
};

struct number_group {
	const struct ccs_path_info *group_name;
	struct ccs_number_entry *member_name;
	int member_name_len;
};

struct ccs_readline_data {
	const char **history;
	int count;
	int max;
	char *search_buffer[MAX_SCREEN_TYPE];
};

struct ccs_screen {
	/* Index of currently selected line on each screen. */
	int current;
	/* Current cursor position on CUI screen. */
	int y;
	/* Columns to shift when displaying. */
	int x;
	/* For editpolicy_line_draw(). */
	int saved_color_current; /* Initialized to -1 */
	int saved_color_y;
};

#define CCS_HEADER_LINES 3

#define CCS_EDITPOLICY_CONF "/etc/ccs/tools/editpolicy.conf"

enum color_type editpolicy_color_head(void);
enum directive_type find_directive(const _Bool forward, char *line);
int editpolicy_get_current(void);
void editpolicy_attr_change(const attr_t attr, const _Bool flg);
void editpolicy_color_change(const attr_t attr, const _Bool flg);
void editpolicy_color_init(void);
void editpolicy_init_keyword_map(void);
void editpolicy_line_draw(void);
void editpolicy_offline_daemon(const int listener, const int notifier);
void editpolicy_optimize(void);
void editpolicy_sttr_restore(void);
void editpolicy_sttr_save(void);
struct path_group *find_path_group_ns(const struct ccs_path_info *ns,
				      const char *group_name);

struct ccs_domain {
	const struct ccs_path_info *domainname;
	const struct ccs_path_info *target; /* This may be NULL */
	const struct transition_entry *d_t; /* This may be NULL */
	const struct ccs_path_info **string_ptr;
	int string_count;
	int number;   /* domain number (-1 if target or is_dd) */
	u8 profile;
	u8 group;
	_Bool is_djt; /* domain jump target */
	_Bool is_dk;  /* domain keeper */
	_Bool is_du;  /* unreachable domain */
	_Bool is_dd;  /* deleted domain */
};

struct domain_policy {
	struct ccs_domain *list;
	int list_len;
	unsigned char *list_selected;
};

struct policy {
	/* Array of "path_group" entries. */
	struct path_group *path_group;
	/* Length of path_group_list array. */
	int path_group_len;
	/* Array of "number_group" entry. */
	struct number_group *number_group;
	/* Length of number_group_list array. */
	int number_group_len;
	/* Array of "address_group" entry. */
	struct address_group *address_group;
	/* Length of address_group_list array. */
	int address_group_len;
	/* Array of "acl_group" entry. */
	char **acl_group[256];
	/* Length of acl_group_list array.*/
	int acl_group_len[256];
	/* Array of string ACL entries. */
	struct generic_entry *generic;
	/* Length of generic_list array. */
	int generic_len;
};

extern enum screen_type active;
extern struct policy p;
extern struct editpolicy_directive directive_map[MAX_DIRECTIVE_TYPE];
extern struct ccs_screen screen[MAX_SCREEN_TYPE];
extern const struct ccs_path_info *current_ns;
