/*
 * pathnametest.c
 *
 * Testing program for various pathname patterns.
 *
 * Copyright (C) 2005  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 */
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
	int i;
	FILE *fp;
	const char *pathname;
	system("dmesg -c > /dev/null");
	pathname = "/proc/ccs/policy/domain_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "<kernel> /domain\\%03oname\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "<kernel> /domain\\12c\n");
		fprintf(fp, "<kernel> /domain\\1cd\n");
		fprintf(fp, "<kernel> /domain\\cde\n");
		fprintf(fp, "<kernel><kernel>\n");
		fprintf(fp, "<kernel>  <kernel>\n");
		fprintf(fp, "<kernel> /<kernel>\n"); // OK
		fprintf(fp, "<kernel> / <kernel>\n");
		fprintf(fp, "<kernel> / /sbin/init\n"); // OK
		fprintf(fp, "<kernel> /bin/\\*\n");
		fprintf(fp, "<kernel> /bin/\\?\n");
		fprintf(fp, "<kernel> /bin/\\\\\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/domain_policy";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		fprintf(fp, "<kernel> /\\377\n");
		for (i = 0; i < 256; i++) fprintf(fp, "4 /file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		for (i = -10; i < 10; i++) fprintf(fp, "%d /filetest\n", i); // 0 <= i <= 7 are OK
		fprintf(fp, "<kernel> / init\n");
		for (i = 0; i < 256; i++) fprintf(fp, "4 /file\\%03o\n", i); // Within a invalid domain. They are ignored.
		fprintf(fp, "<kernel> /zzz\\377zzz\n");
		for (i = 0; i < 8; i++) fprintf(fp, "%d /file\\$%d\n", i, i); // Dropping execute permission.
		for (i = 0; i < 8; i++) fprintf(fp, "%d /file%d\\*\n", i, i); // Dropping execute permission.
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/file_pattern";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "/file\\%03o\n", i); // These are not patterns.
		fprintf(fp, "/file\\$\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/daemon_programs";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "/file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "/file\\$\n");
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/readable_files";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "/file\\%03o\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "/file\\$\n");
		fclose(fp);
	}
	system("dmesg -c");
	pathname = "/proc/ccs/policy/trusted_domains";
	if ((fp = fopen(pathname, "w")) == NULL) {
		fprintf(stderr, "Can't open %s\n", pathname);
	} else {
		for (i = 0; i < 256; i++) fprintf(fp, "<kernel> /domain\\%03oname\n", i); // i == 0 or 041 <= i <= 0176 are NG
		fprintf(fp, "<kernel> /domain\\12c\n");
		fprintf(fp, "<kernel> /domain\\1cd\n");
		fprintf(fp, "<kernel> /domain\\cde\n");
		fprintf(fp, "<kernel><kernel>\n");
		fprintf(fp, "<kernel>  <kernel>\n");
		fprintf(fp, "<kernel> /<kernel>\n"); // OK
		fprintf(fp, "<kernel> / <kernel>\n");
		fprintf(fp, "<kernel> / /sbin/init\n"); // OK
		fprintf(fp, "<kernel> /bin/\\*\n");
		fprintf(fp, "<kernel> /bin/\\?\n");
		fprintf(fp, "<kernel> /bin/\\\\\n"); // OK
		fclose(fp);
	}
	system("dmesg -c");
	return 0;
}
