/*
 * obsolete_chksymlink.c
 *
 * Mirror symbolic links from root to the given directory.
 *
 * Copyright (C) 2005  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program is intended to create minimal symbolic links for chroot'ed environment.
 *
 * This program is obsolete.
 */
// gcc -Wall -O3 chksymlink.c
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/socket.h>
#include <stdlib.h>

#define PAGE_SIZE 8192

int main(int argc, char *argv[]) {
	static char filename[PAGE_SIZE], cwd[PAGE_SIZE];
	int sock_fd[2];
	int c, len;
	if (argc != 2) {
		fprintf(stderr, "find / -type l -print0 | %s base_dir | cpio -p0 base_dir\n", argv[0]);
		return 1;
	}
	memset(cwd, 0, sizeof(cwd));
	if (chdir(argv[1]) || !getcwd(cwd, sizeof(cwd) - 4) || !cwd[0] || strcmp(cwd, "/") == 0) {
		fprintf(stderr, "Can't chdir to %s\n", argv[1]);
		return 1;
	}
	if (cwd[strlen(cwd) - 1] != '/') strcat(cwd, "/"); // strlen(cwd) < sizeof(cwd) - 4
	if (socketpair(AF_UNIX, SOCK_STREAM, 0, sock_fd)) {
		fprintf(stderr, "Can't create socketpair\n");
		return 1;
	}
	switch (fork()) {
	case 0:
		fclose(stdin);
		close(sock_fd[0]);
		if (chroot(".") || chdir("/")) {
			fprintf(stderr, "Can't chroot\n");
			exit(1);
		}
		while (1) {
			struct stat buf;
			char ch;
			memset(filename, 0, sizeof(filename));
			if (recv(sock_fd[1], filename, sizeof(filename) - 1, 0) != sizeof(filename) - 1) break;
			ch = (lstat(filename, &buf) == 0);
			//if (ch) fprintf(stderr, "Found %s\n", filename);
			if (send(sock_fd[1], &ch, sizeof(ch), 0) != sizeof(ch)) break;
		}
		close(sock_fd[1]);
		exit(0);
	case -1:
		fprintf(stderr, "Can't fork\n");
		exit(1);
	}
	close(sock_fd[1]);
	memset(filename, 0, sizeof(filename));
	goto next;
	while ((c = fgetc(stdin)) != EOF) {
		static char symlink_data[PAGE_SIZE];
		char ch;
		if ((filename[len++] = (char) c) != '\0') {
			if (len == sizeof(filename)) {
				fprintf(stderr, "Filename too long.\n");
				break;
			}
			continue;
		}
		if (filename[0] != '/') {
			fprintf(stderr, "Invalid symlink. %s\n", filename);
			goto next;
		}
		if (strncmp(filename, cwd, strlen(cwd)) == 0) {
			goto next;
		}
		memset(symlink_data, 0, sizeof(symlink_data));
		if (readlink(filename, symlink_data, sizeof(symlink_data) - 1) <= 0) {
			fprintf(stderr, "Invalid symlink. %s\n", filename);
			goto next;
		}
		if (symlink_data[0] != '/') {
			static char tmp_path1[PAGE_SIZE], tmp_path2[PAGE_SIZE];
			char *cp = strrchr(filename, '/');
			if (!cp) {
				fprintf(stderr, "Invalid path. %s\n", filename);
				exit(1);
			}
			*cp = '\0';
			memset(tmp_path1, 0, sizeof(tmp_path1));
			memset(tmp_path2, 0, sizeof(tmp_path2));
			snprintf(tmp_path1, sizeof(tmp_path1) - 1, "%s/%s", filename, symlink_data);
			*cp = '/';
			if (strchr(symlink_data, '/')) {
				cp = strrchr(tmp_path1, '/');
				if (!cp) {
					fprintf(stderr, "Invalid path. %s\n", tmp_path1);
					exit(1);
				}
				*cp = '\0';
				if (chdir(tmp_path1) || !getcwd(tmp_path2, sizeof(tmp_path2) - 1) || tmp_path2[0] != '/') goto next;
				memset(symlink_data, 0, sizeof(symlink_data));
				snprintf(symlink_data, sizeof(symlink_data) - 1, "%s/%s", tmp_path2, cp + 1);
				//fprintf(stderr, "%s -> %s\n", filename, symlink_data);
			} else {
				snprintf(symlink_data, sizeof(symlink_data) - 1, "%s", tmp_path1);
				//fprintf(stderr, "%s -> %s\n", filename, symlink_data);
			}
		}
		if (send(sock_fd[0], symlink_data, sizeof(symlink_data) - 1, 0) != sizeof(symlink_data) - 1 || recv(sock_fd[0], &ch, sizeof(ch), 0) != sizeof(ch)) {
			fprintf(stderr, "I/O error.\n");
			break;
		}
		if (!ch) goto next;
		printf("%s", filename);
		putchar('\0');
	next: ;
		len = 0;
	}
	close(sock_fd[0]);
	fflush(stdout);
	return 0;
}
