/*
 * findtemp.c
 *
 * Scan the file access policy and display nonexistent path.
 *
 * Copyright (C) 2005  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program checks the existence for pathnames which have the write permission,
 * and displays the pathname if nonexistent, for such pathnames are likely temporary.
 *
 */
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

static void NormalizeLine(unsigned char *buffer) {
	unsigned char *sp = buffer, *dp = buffer;
	int first = 1;
	while (*sp && (*sp <= 32 || 127 <= *sp)) sp++;
	while (*sp) {
		if (!first) *dp++ = ' ';
		first = 0;
		while (32 < *sp && *sp < 127) *dp++ = *sp++;
		while (*sp && (*sp <= 32 || 127 <= *sp)) sp++;
	}
	*dp = '\0';
}

static int decode(const char *ascii, char *bin) {
	char c, d, e;
	while ((c = *bin++ = *ascii++) != '\0') {
		if (c == '\\') {
			c = *ascii++;
			switch (c) {
			case '\\':      /* "\\" */
				continue;
			case '0':       /* "\ooo" */
			case '1':
			case '2':
			case '3':
				if ((d = *ascii++) >= '0' && d <= '7' && (e = *ascii++) >= '0' && e <= '7') {
					const unsigned char f =
						(((unsigned char) (c - '0')) << 6) +
						(((unsigned char) (d - '0')) << 3) +
						(((unsigned char) (e - '0')));
					if (f && (f <= ' ' || f >= 127)) {
						*(bin - 1) = f;
						continue; /* pattern is not \000 */
					}
				}
			}
			return 0;
		} else if (c <= ' ' || c >= 127) {
			return 0;
		}
	}
	return 1;
}

int main(int argc, char *argv[]) {
	const char **pattern_list = NULL;
	int pattern_list_count = 0;
	int i, j;
	static char buffer[16384], buffer2[sizeof(buffer)];
	while (memset(buffer, 0, sizeof(buffer)), fgets(buffer, sizeof(buffer) - 1, stdin) != NULL) {
		struct stat buf;
		char *cp = strchr(buffer, '\n');
		int perm;
		if (cp) *cp = '\0';
		else if (!feof(stdin)) break;
		if (sscanf(buffer, "%u", &perm) != 1 || (perm & 2) == 0 || (cp = strchr(buffer, ' ')) == NULL) continue;
		memmove(buffer, cp, strlen(cp) + 1);
		NormalizeLine(buffer);
		if (buffer[0] != '/' || !decode(buffer, buffer2)) continue;
		if (lstat(buffer2, &buf) == 0) continue;
		for (i = 0; i < pattern_list_count; i++) {
			if (strcmp(pattern_list[i], buffer) == 0) break;
		}
		if (i < pattern_list_count) continue;
		if ((pattern_list = (const char **) realloc(pattern_list, sizeof(const char *) * (pattern_list_count + 1))) == NULL ||
			(pattern_list[pattern_list_count++] = strdup(buffer)) == NULL) {
			fprintf(stderr, "Out of memory.\n");
			exit(1);
		}
	}
	for (i = 0; i < pattern_list_count; i++) {
		for (j = i + 1; j < pattern_list_count; j++) {
			if (strcmp(pattern_list[i], pattern_list[j]) > 0) {
				const char *tmp = pattern_list[i]; pattern_list[i] = pattern_list[j]; pattern_list[j] = tmp;
			}
		}
	}
	for (i = 0; i < pattern_list_count; i++) printf("%s\n", pattern_list[i]);
	return 0;
}
