/*
 * dumpsymlink.cpp
 *
 * Dump symbolic linked files under root directory.
 *
 * Copyright (C) 2005  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program generates list of symbolic links in a system.
 * The output of this program is passed to makesymlink.
 *
 */
#include <iostream>
#include <sstream>
#include <unistd.h>
using namespace std;

static string encode(const string filename) {
	ostringstream buf;
	int index = 0;
	unsigned char c;
	while ((c = filename[index++]) != '\0') {
		if (c == '\\') buf << "\\\\";
		else if (c > ' ' && c < 127) buf << c;
		else buf << '\\' << (char) ((c >> 6) + '0') << (char) (((c >> 3) & 7) + '0') << (char) ((c & 7) + '0');
	}
	return buf.str();
}

int main(int argc, char *argv[]) {
	string filename;
	if (argc > 1) {
		cerr << "find / -type l ! -fstype proc -print0 | " << argv[0] << " [ > symlinked_filelist_file ]" << endl;
		return 0;
	}
	while (getline(cin, filename, '\0')) {
		static char symlink_data[4096];
		memset(symlink_data, 0, sizeof(symlink_data));
		if (readlink(filename.c_str(), symlink_data, sizeof(symlink_data) - 1) <= 0) {
			cerr << "Invalid symlink. " << filename << endl;
			continue;
		}
		cout << encode(filename) << " " << encode(symlink_data) << endl;
	}
	return 0;
}
