/*
 * dumplink.cpp
 *
 * Dump linked files under root directory.
 *
 * Copyright (C) 2005  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program generates list of links in a system.
 * The output of this program is passed to makelink.
 *
 */
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
using namespace std;

static string encode(const string filename) {
	ostringstream buf;
	int index = 0;
	unsigned char c;
	while ((c = filename[index++]) != '\0') {
		if (c == '\\') buf << "\\\\";
		else if (c > ' ' && c < 127) buf << c;
		else buf << '\\' << (char) ((c >> 6) + '0') << (char) (((c >> 3) & 7) + '0') << (char) ((c & 7) + '0');
	}
	return buf.str();
}

typedef struct {
	dev_t dev;
	ino_t ino;
	string name;
} LINK_ENTRY;

int main(int argc, char *argv[]) {
	vector <LINK_ENTRY *> linked_filelist;
	string filename;
	if (argc > 1) {
		cerr << "find / -links +1 ! -type d -print0 | " << argv[0] << " [ > linked_filelist_file ]" << endl;
		return 0;
	}
	while (getline(cin, filename, '\0')) {
		LINK_ENTRY *entry = new LINK_ENTRY;
		struct stat buf;
		if (lstat(filename.c_str(), &buf) != 0) continue;
		if (S_ISDIR(buf.st_mode)) continue;
		if (buf.st_nlink == 1) continue;
		entry->dev = buf.st_rdev;
		entry->ino = buf.st_ino;
		entry->name = encode(filename);
		linked_filelist.push_back(entry);
	}
	while (linked_filelist.size() > 0) {
		LINK_ENTRY *ptr1 = linked_filelist[0];
		cout << ptr1->name;
		for (int i = 1; i < (int) linked_filelist.size(); i++) {
			LINK_ENTRY *ptr2 = linked_filelist[i];
			if (ptr1->dev == ptr2->dev && ptr1->ino == ptr2->ino) {
				cout << " " << ptr2->name;
				linked_filelist.erase(linked_filelist.begin() + i);
				i--;
			}
		}
		linked_filelist.erase(linked_filelist.begin());
		cout << endl;
	}
	return 0;
}
