<?php
//include_once('config_auth.ini.php');	// 設定用ファイル
/**
 * JugemKey Authentication API Class
 * see: https://secure.jugemkey.jp/api/auth/
 *
 * (PHP5)
 *
 *
 * @copyright (c)paperboy&co, 2006 All rights reserved.
 * @author paperboy&co. <http://www.paperboy.co.jp/>
 * @version 0.1 2006/05/31
 * @author one of user
 * @version 0.1.1 2006/06/04 Pearが利用できない環境下用に変更/user edit
 * @version 0.1.2 2007/04/13 Pearが利用できない環境下用に変更/user edit
 *
 * ソースコード形式かバイナリ形式か、変更するかしないかを問わず、以下の
 * 条件を満たす場合に限り、再頒布および使用が許可されます。
 * 
 *   * ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、および
 *     下記免責条項を含めること。
 *   * バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の資料に、
 *     上記の著作権表示、本条件一覧、および下記免責条項を含めること。
 *   * 書面による特別の許可なしに、本ソフトウェアから派生した製品の宣伝
 *     または販売促進に、<組織>の名前またはコントリビューターの名前を使用
 *     してはならない。
 * 
 * 本ソフトウェアは、著作権者およびコントリビューターによって「現状のまま」
 * 提供されており、明示黙示を問わず、商業的な使用可能性、および特定の目的に
 * 対する適合性に関する暗黙の保証も含め、またそれに限定されない、いかなる
 * 保証もありません。著作権者もコントリビューターも、事由のいかんを問わず、
 * 損害発生の原因いかんを問わず、かつ責任の根拠が契約であるか厳格責任で
 * あるか（過失その他の）不法行為であるかを問わず、仮にそのような損害が発生
 * する可能性を知らされていたとしても、本ソフトウェアの使用によって発生した
 * （代替品または代用サービスの調達、使用の喪失、データの喪失、利益の喪失、
 * 業務の中断も含め、またそれに限定されない）直接損害、間接損害、偶発的な損害、
 * 特別損害、懲罰的損害、または結果損害について、一切責任を負わないものとします。
 *
 *
 * 使い方
 * 
 * 必要なもの
 * ・PEAR HTTP_Requestクラス
 * ・JugemKey APIキー
 * 
 * (1)JugemKeyログイン用のURLを取得し、ユーザをそこに誘導する
 * 
 * // JugemKey認証APIクラスを生成
 * $jugemkey = new Auth_JugemKey(APIKEY, SECRET);
 * 
 * // JugemKey認証後に呼ばれるコールバックURLの設定(必須)
 * $callback_url = 'http://yoursite/callback';
 * 
 * // JugemKeyログイン用のURLを取得
 * $login_url = $jugemkey->getLoginUrl($callback_url);
 * 
 * // リダイレクトやHTMLのリンクなどでユーザをログイン用URLに誘導
 * ・header('Location: '.$login_url);
 * ・echo "<a href=\"{$login_url}\">ログインはこちらから</a>";
 *
 * # ユーザがJugemKeyにログインすると、コールバックURLが呼ばれます
 * 
 * (2)コールバックされたURLで、ユーザ情報を取得する
 * 
 * // JugemKey認証APIクラスを生成
 * $jugemkey = new Auth_JugemKey(APIKEY, SECRET[);
 * 
 * // コールバックURLに渡されたfrobの値を利用して、ユーザ情報を取得
 * $data = $jugemkey->getToken($frob);
 * 
 * print_r($data); // => Array ( [title] => username [token] => token )
 *
 * # 取得したユーザ情報をもとに、アプリケーションごとの処理を行ってください
 *
 */


//require_once 'HTTP/Request.php';
//require_once ($_CONF['path_system'] . 'pear/HTTP/Request.php');

class Auth_JugemKey
{
//    const JUGEMKEY_URL = 'http://dbg.jugemkey.jp';
    const JUGEMKEY_URL = 'https://secure.jugemkey.jp';
    const AUTH_API_URL = 'http://api.jugemkey.jp/api/auth';


    private $apikey;
    private $secret;

    public function __construct($apikey, $secret)
    {
        $this->apikey = $apikey;
        $this->secret = $secret;
    }

    public function getToken($frob)
    {
		if (!LIVEDOOR_AUTHFLG) {
			return;
		}

        $url  = Auth_Jugemkey::AUTH_API_URL.'/token';
        $date = $this->getDate();
        $sig  = $this->getTokenSig($date, $frob);

        // pearが使えなかったので代用
        $fp = fsockopen('api.jugemkey.jp', 80, $errno, $errstr, 10);
        if (!$fp) {
            echo "$errstr ($errno)<br />\n";
        } else {
            $out = "GET /api/auth/token HTTP/1.1\r\n";
            $out .= "Host: api.jugemkey.jp\r\n";
            $out .= "X-JUGEMKEY-API-KEY: ".$this->apikey."\r\n";
            $out .= "X-JUGEMKEY-API-FROB: ".$frob."\r\n";
            $out .= "X-JUGEMKEY-API-CREATED: ".$date."\r\n";
            $out .= "X-JUGEMKEY-API-SIG: ".$sig."\r\n";
            $out .= "Connection: Close\r\n\r\n";
            fwrite($fp, $out);
            $ret = "";
            while (!feof($fp)) {
                $ret .= fgets($fp, 2048);

            }
            fclose($fp);
        }
        $pattern = '/(\s*<title.*>)(.*)(<\/title>)/';
        preg_match_all($pattern,$ret,$getAry);
        $id = "";
		if (isset($getAry[2][0])) {
	        $id = $getAry[2][0];
		}
        $pattern = '/(\s*<token.*>)(.*)(<\/token>)/';
        preg_match_all($pattern,$ret,$getAry);
        $token = "";
		if (isset($getAry[2][0])) {
	        $token = $getAry[2][0];
		}

        $data = array(
            'title' => JUGEM_SERVICEID . $id,
            'token' => $token,
        );

        return $data;
    }

    public function getLoginUrl($options = null)
    {
        $defaults = array(
            'api_key' => $this->apikey,
            'mode'    => 'auth_issue_frob',
            'perms'   => 'read',
        );

        if ($options && is_array($options)) {
            $options = array_merge($defaults, $options);
        } else {
            $options = array_merge($defaults, array('callback_url'=>$options));
        }

        $options['api_sig'] = $this->getAuthSig($options['perms'], $options['callback_url']);

        return Auth_JugemKey::JUGEMKEY_URL.'/?'.http_build_query($options);
    }

    private function getTokenSig($date, $frob)
    {
        $str = $this->apikey.$date.$frob;    
        $sig = $this->hmacSha1($this->secret, $str);
        return $sig;
    }

    private function getAuthSig($perms, $callback_url)
    {
        $str = $this->apikey.$callback_url.$perms;
        $sig = $this->hmacSha1($this->secret, $str);
        return $sig;
    }

    private function getDate()
    {
        return gmdate('Y-m-d').'T'.gmdate('H:i:s').'Z';
    }

    private function hmacSha1($key, $data)
    {
        $blocksize = 64;
        if (strlen($key) > $blocksize) {
            $key = pack("H*", sha1($key));
        }
        $key  = str_pad($key, $blocksize, chr(0x00));
        $ipad = str_pad("", $blocksize, chr(0x36));
        $opad = str_pad("", $blocksize, chr(0x5c));
        $k_ipad = $key ^ $ipad ;
        $k_opad = $key ^ $opad;

        return sha1($k_opad . pack("H*", sha1($k_ipad . $data)));
    }
}

?>
