<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/login.class.php');
	include_once(TODOTASK_AUTH_API_DIR.'/authhatena.class.php');	// hatena認証用クラス
	include_once(TODOTASK_AUTH_API_DIR.'/authjugem.class.php');	// Jyugem認証用クラス
	include_once(TODOTASK_AUTH_API_DIR.'/authlivedoor.class.php');	// Livedoor認証用クラス

	// ページロード
	$page = gfPageLoad();

	$page->title = TITLE_USERLOGIN;
	$page->definput_flg = "1";	//画面入力補助用のjsを読み込む:1 読み込まない:
	$page->user_id = gfIssetPOST('id',""); 
	$page->pass = gfIssetPOST('pass',""); 
	$page->staylogin = gfIssetPOST('staylogin',""); 
	$page->group_no = gfIssetGET('group_no',""); 
	$page->csrf = gfIssetPOST('csrf',""); 	 //CSRF対策

	// check page parameter
	$page->chkPage();

	$sMsg = "";	 

	$page->backurl = ""; //戻り先URL
	if ($page->group_no!="") {
		$page->backurl = "tasklist.php?group_no=".$page->group_no;
	}

	$objLogin = new Login();
	//ログイン状態解除
	$objLogin->UnsetLogin();

	if ($page->user_id == "" || $page->pass == "") {
		$sMsg = LOGIN_ART_001;
	} else if (($page->pass != gfFixUpStr($page->pass))
				|| ($page->user_id != gfFixUpStr($page->user_id))) {
		$sMsg = LOGIN_ART_010;
	} else {
		// CSRFのチェック
		$objLogin->chk_csrf($page,$page->csrf,"1");	// 	@todo API対応の可能性を拒否しないので緩めのcsrf

		if ($objLogin->ChkLoginDB($page->user_id,$page->pass)) {

			// Cookieに保存する
			if ($page->staylogin != '1') {
				$objLogin->UnsetCookies();
			} else {
				$objLogin->SetLogin();
			}

			//ログインした状態でログイン呼び出し画面にもどる
			$objLogin->ctrl_movepage($page->backurl);
			exit;
		} else {
			$sMsg = LOGIN_ERR_007;
		}
	}

	$page->art_msg = $sMsg;

	// CSRFの発行
	$page->csrf = sha1("1".CSRF_SEED);


	// ドキュメントルート
//	$docroot = "http://".$_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];

// はてな認証に必要なリンクの生成
// 定数がクラス内に切ってあるので環境にあわせ変更してください
	$obj_auth = new AuthHatena(HATENA_APIKEY, HATENA_SECRET);
	$page->hatenaloginurl = $obj_auth->getLoginUrl();

// ジュゲム認証に必要なリンクの生成
// 定数がクラス内に切ってあるので環境にあわせ変更してください
	// JugemKey認証APIクラスを生成
	$jugemkey = new Auth_JugemKey(JUGEM_APIKEY, JUGEM_SECRET);
	// JugemKey認証後に呼ばれるコールバックURLの設定
	$callback_url = ROOT_URL.'authapi_jugem.php';
	// JugemKeyログイン用のURLを取得
	$page->jyugemuloginurl = $jugemkey->getLoginUrl($callback_url);

// LiveDoor認証に必要なリンクの生成
// 定数がクラス内に切ってあるので環境にあわせ変更してください
	$obj_auth = new AuthLiveDoor(LIVEDOOR_APIKEY, LIVEDOOR_SECRET);
	$page->livedoorloginurl = $obj_auth->getLoginUrl();


	$page->display('/user/login.php');


	// ページ終了処理
	gfPageUnLoad();

?>
