<?php
// 設定の読み込み
require_once(dirname(__FILE__).'/../../config/todo.ini.php');
require_once(TODOTASK_CTRL_DIR.'/page.class.php');
require_once(TODOTASK_DIR.'/app/controllers/login.class.php');


// 主にラップ関数群

set_error_handler('error_handler');

// メンテナンスモード
if (MAINTE_MODE && MAINTE_OWNER != $_SERVER['REMOTE_ADDR']) {
	gfMsgWindow(null ,MSG_MODE_NOTE ,MAINTE_TITLE , MAINTE_MSG."your host ".$_SERVER['REMOTE_ADDR'],"" ,MSG_NOR);
}


function error_handler($errno, $message, $file, $line) {
	$sMsg = date('y/m/d H:i:s')." File:".$file." At:".$line."  Error No:".$errno ."  -> ". $message;
	gfDebug($sMsg,$errno);
//	exit;	
}

function gfDebug($sMsg, $loglv=0) {
	//
	$vars = get_defined_vars();
	if (LOG_LV==1) {
		$filename = TODOTASK_LOGS_ERR;
//		chmod(TODOTASK_LOGS, 0667);		
		if((is_writable($filename)) ){
			gfWriteFile($filename, $sMsg."\n");
//			gfWriteFile($filename, $sMsg.var_export($vars,true));
		}
		gfDebugPrint($sMsg);
	} else if (LOG_LV>1) {
		gfDebugPrint($sMsg);
	}

	// エラーメールを送信する必要があるとき
	if (LOG_SENDMAIL) {
		require_once(TODOTASK_CTRL_DIR.'/email.class.php');
		// 登録メールを送信する。
		$objMail = new EMail();
		$objMail->SendErrorMail($sMsg);
	}

}

function gfDebugPrint($sMsg) {
	print($sMsg);
}

// ログファイルに記録
function gfHackTryLog($sProc) {
	$logstr = date('y/m/d H:i:s')."\n".$sProc
		."\n---SERVER---\n".var_export($_SERVER,true)
		."\n---SESSION---\n".var_export($_SESSION,true)
		."\n---COOKIE---\n".var_export($_COOKIE,true)."\n\n";
	$filename = TODOTASK_LOGS_HACK;
	if( LOG_LV >= 1 ){
		gfWriteFile($filename, $logstr);
	}
}

// ファイルの削除
function gfDelFile($filename) {
	if (file_exists($filename)) {
		$ret = unlink($filename);
	}
	return $ret;
}

// ファイルの書き込み
function gfWriteFile($filename, $setstr) {

	if (is_writable($filename)|| !file_exists($filename)) {
		$fp = fopen($filename, "a");
		if ($fp==0) {
			return false;			
		}
		fwrite( $fp, $setstr);
		fclose( $fp );
	} else {
		return false;
	}
	return true;
}

// マイクロ秒の取得
function gfGetMicrotime() {
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}

// PAGEをスタートさせるときに共通で読み込む関数
function gfPageLoad($session_flg = true) {

	// ページ都度読み込むかはサーバーの設定による
	if (SESSION_FLG && $session_flg) {
		// セッション開始
		session_start();
		// セッションIDの振りなおし
		session_regenerate_id(true);
	}

	// E_NOTICE を表示させるのもおすすめ（初期化されていない
	// 変数、変数名のスペルミスなど…）
//	error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);
//	error_reporting(E_ERROR | E_WARNING | E_PARSE);
	error_reporting(E_ALL|E_STRICT);	// すべて表示する
//	error_reporting(0);		// すべて表示しない

//	global $starttime;
//	$starttime=(microtime());
//	//$starttime=(date('y/m/d H:i:s').(float)microtime());


	$page = new Page();
	return $page;
}

// PAGEを終了させるときに共通で読み込む関数
function gfPageUnLoad() {
//	global $starttime;
//	if (DEBUG_FLG) {
//		gfDebugPrint((float)(microtime()-$starttime));
//	}
	exit;
}


// GET変数の初期化&リロード防止
function gfIssetGET($getid,$intcd="") {
	$ret=$intcd; 
	if (isset($_GET[$getid])) { 
		$ret = $_GET[$getid];
		$_GET[$getid] = "";
	}
	return $ret; 
}

// POST変数の初期化&リロード防止
function gfIssetPOST($getid,$intcd="") {
	$ret=$intcd; 
	if (isset($_POST[$getid])) { 
		$ret = $_POST[$getid];
		$_POST[$getid] = "";
	}
	return $ret; 
}

// FILE変数の初期化&リロード防止
function gfIssetFILE($getid,$intcd="") {
	$ret=$intcd; 

	if (!isset($_FILES[$getid])) {
		return $ret; 
	}
	if (!isset($_FILES[$getid]["tmp_name"])) {
		return $ret; 
	}
	if ($_FILES[$getid]["tmp_name"]=="none") {
		return $ret; 
	}
	$ret = $_FILES[$getid];

	unset($_FILES[$getid]);
	return $ret; 
}

// レコードセットから情報を取得する為の関数
function gfGetDBFields($row,$sFields){
	$sRet = "";
	if (isset($row[$sFields])) {
		// 取り出した文字列を表示
		$sRet = gfPageStr($row[$sFields]);
	}
	return $sRet;
}

// 文字列の数字型チェック
function gfChkNum(&$chkstr,$defnum="") {

	if ($chkstr=="") {
		if ($defnum != "") {
			$chkstr = $defnum;
		} else {
			return false;
		}
	}

	if (!is_numeric($chkstr)) {
		$chkstr = $defnum;
		return false;
	}
	return true;
}

//数字の最大値最小値チェック
function gfChkMaxMin(&$chknum,$minnum=0,$maxnum=100) {
	if (!is_numeric($chknum)) {
		$chknum = $minnum;
		return false;
	}
	if ($chknum < $minnum) {
		$chknum = $minnum;
	} else if ($chknum > $maxnum) {
		$chknum = $maxnum;
	}
	return true;
}

// 文字列の日付型チェック
function gfChkDate(&$chkstr,$defdate="") {
	$tmp = "";
	if ($chkstr=="") {
		if ($defdate != "") {
			$chkstr = $defdate ;
		} else {
			return false;
		}
	}
	// 日付区切りの変更 
	$chkstr = str_replace(array(".","-"),'/',$chkstr);
	// php:ver5.1.0 失敗時に -1 の代わりに FALSE を返す
	$tmp = strtotime($chkstr);
	if ($tmp==-1 || $tmp==false) {
		$chkstr = $defdate ;
		return false;
	} else {
		$aryDate = getdate($tmp);
		$chkstr = 
			$aryDate["year"]."."
			.$aryDate["mon"]."."
			.$aryDate["mday"]; 
	}
	return true;
}

// 格納形態の文字コードから文字列を表示形態の文字コードへ
function gfPageStr($getstr) {
	$sRet = mb_convert_encoding($getstr, PAGE_ENCTYPE, DB_ENCTYPE);
	return $sRet;
}

// 文字コードに半角英数字以外を含ませない
function gfChkIDType(&$getstr,$errtrap="1") {

	// ID形式は半角英数字のみ
	if (!preg_match('/^[a-zA-Z0-9_\-\|]{1,}$/',$getstr)){ 
		if ($errtrap=="1") {
			return 0;
		} else {
			$getstr = "";
		}
	}
	return 1;
}

// 入力を表示文字列からDB格納型へ
function gfQt($getstr,$rnflg=0,$maxlen=0) {
	$ret = "";
	$ret = " '" .gfFixUpStr($getstr,$rnflg,$maxlen) . "' ";
	return $ret; 
}

function gfQtNum($chkstr,$defnum="") {
	if (!gfChkNum($chkstr,$defnum)) {
		$chkstr = "null ";
	}

	return $chkstr;
}


// 入力を表示文字列からDB格納型へ
function gfFixUpStr($getstr,$rnflg=0,$maxlen=0) {
	$str = $getstr;

	// Nullバイトアタック対応
	$getstr = str_replace("\0",'',$getstr);

	// 半角カタカナ処理
	$str = mb_convert_kana($str, "KV",PAGE_ENCTYPE);

	// 文字コーディング
	$str = mb_convert_encoding($str, DB_ENCTYPE, "auto");

	// 禁則文字列処理
	// エスケープ文字をエスケープ
	$str = addslashes($str);			//\マークを入力する必要があるか…？

	// タグ処理
	$str = htmlspecialchars($str);

	// シングルクオート処理
	$str = str_replace("\'",'\'\'',$str);
	// バッククオート処理
	$str = str_replace("\`",'\`\`',$str);
	

	// 改行コードの除去
	if ($rnflg==0) {
//		$str = preg_replace(array('/\r\n/','/\r/','/\n/'),array('','',''),$str);
		$str = str_replace(array("\r\n","\r","\n"),array("","",""),$str);
	}

	// 文字列長の指定がある場合ここで切り捨て。
	if ($maxlen != 0 ){
		if (strlen($str) > $maxlen) {
			$str = substr($str, 0, $maxlen);
		}
	}

	return $str;
}

// パスワード暗号化
function gfCrypt($getStr) {
	$ret = crypt($getStr,CRYPT_SEED);

	return $ret;
}

// メッセージページを表示する
function gfMsgWindow($page ,$mode = MSG_MODE_NOTE ,$msgtitle="" , $msgbody="" ,$backurl=ROOT_URL ,$errflg=MSG_NOR) {
	if (!isset($page->init)) {
		// ページ作成
		$page = gfPageLoad(false);
	} 
	$page->mode = $mode; 
	$page->title = $msgtitle; 
	$page->art_msg = $msgbody; 
	$page->backurl = $backurl; 
	$page->errflg = $errflg; 


	if ($mode==MSG_MODE_NOTE) {
		$page->display('/common/sysmsg.inc.php');
	} else if($mode == MSG_MODE_REDIRECT)  {
		$page->display('/common/msg.inc.php');
	}
	exit;
}



?>