/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.Map;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.core.model.DataTypeDeclaration;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.core.model.StandardSQLDataType;
import org.tmdmaker.core.model.rule.ImplementRule;

public class MultivalueOrEntity
extends AbstractEntityModel {
    protected MultivalueOrEntity() {
    }

    protected static MultivalueOrEntity build(AbstractEntityModel source, String typeName) {
        MultivalueOrEntity target = new MultivalueOrEntity();
        if (typeName == null || typeName.isEmpty()) {
            typeName = "MO";
        }
        target.setName(String.valueOf(source.getName()) + "." + typeName);
        target.setEntityType(source.getEntityType());
        target.addAttribute(MultivalueOrEntity.createTypeCode(typeName));
        ImplementRule.setModelDefaultValue(target);
        return target;
    }

    private static Attribute createTypeCode(String typeName) {
        Attribute attribute = new Attribute();
        attribute.setName(String.valueOf(typeName) + "\u30b3\u30fc\u30c9");
        attribute.setImplementName(attribute.getName());
        attribute.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.SMALLINT, null, null));
        return attribute;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSurrogateKey());
        for (Map.Entry rk : this.reusedIdentifiers.entrySet()) {
            returnValue.addAll(((ReusedIdentifier)rk.getValue()).getIdentifiers());
        }
        return returnValue;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().isEmpty() && this.getModelTargetConnections().size() == 1;
    }

    @Override
    public MultivalueOrEntity getCopy() {
        MultivalueOrEntity copy = new MultivalueOrEntity();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

