/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.core.model.SurrogateKey;

public class KeyModels
implements Iterable<KeyModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<KeyModel> keys = new ArrayList<KeyModel>();
    private KeyModel masterKey;
    private SurrogateKey surrogateKey;

    public KeyModel getMasterKey() {
        return this.masterKey;
    }

    public void add(KeyModel keyModel) {
        if (keyModel.isMasterKey()) {
            this.add(0, keyModel);
        } else {
            this.keys.add(keyModel);
        }
    }

    private void add(int index, KeyModel keyModel) {
        if (keyModel.isMasterKey()) {
            this.setMasterKey(keyModel);
            this.keys.add(0, keyModel);
        } else {
            this.keys.add(index, keyModel);
        }
    }

    private void setMasterKey(KeyModel keyModel) {
        if (this.masterKey != null) {
            this.masterKey.setMasterKey(false);
        }
        this.masterKey = keyModel;
    }

    public void replaceKeyModel(int index, KeyModel keyModel) {
        this.remove(index);
        this.add(index, keyModel);
    }

    public void remove(int index) {
        KeyModel model = this.keys.get(index);
        if (model == null) {
            return;
        }
        if (model.isMasterKey()) {
            this.setMasterKey(null);
        }
        this.keys.remove(index);
    }

    public void remove(KeyModel model) {
        if (model.isMasterKey()) {
            this.setMasterKey(null);
        }
        this.keys.remove(model);
    }

    public KeyModel get(int index) {
        return this.keys.get(index);
    }

    public int size() {
        return this.keys.size();
    }

    @Override
    public Iterator<KeyModel> iterator() {
        return new KeyModelIterator(this.keys);
    }

    public SurrogateKey getSurrogateKey() {
        if (this.surrogateKey == null) {
            this.surrogateKey = new SurrogateKey();
        }
        return this.surrogateKey;
    }

    protected void setSurrogateKey(SurrogateKey surrogateKey) {
        this.surrogateKey = surrogateKey;
    }

    public void copyTo(KeyModels to) {
        to.setSurrogateKey(this.getSurrogateKey());
        for (KeyModel k : this) {
            to.add(k.getCopy());
        }
    }

    static class KeyModelIterator
    implements Iterator<KeyModel> {
        private List<KeyModel> keyModelList;
        private int index = 0;

        public KeyModelIterator(List<KeyModel> keyModelList) {
            this.keyModelList = keyModelList;
        }

        @Override
        public boolean hasNext() {
            return this.keyModelList.size() > this.index;
        }

        @Override
        public KeyModel next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.keyModelList.get(this.index++);
        }

        @Override
        public void remove() {
            this.keyModelList.remove(this.index);
        }
    }
}

