/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;

public class PreferencePatternFilter
extends PatternFilter {
    private Map<WorkbenchPreferenceExtensionNode, Collection<String>> keywordCache = new HashMap<WorkbenchPreferenceExtensionNode, Collection<String>>();

    private String[] getKeywords(Object element) {
        if (element instanceof WorkbenchPreferenceExtensionNode) {
            WorkbenchPreferenceExtensionNode workbenchNode = (WorkbenchPreferenceExtensionNode)element;
            Collection<String> keywordCollection = this.keywordCache.get(element);
            if (keywordCollection == null) {
                keywordCollection = workbenchNode.getKeywordLabels();
                this.keywordCache.put(workbenchNode, keywordCollection);
            }
            return keywordCollection.toArray(new String[keywordCollection.size()]);
        }
        return new String[0];
    }

    @Override
    public boolean isElementSelectable(Object element) {
        return element instanceof WorkbenchPreferenceExtensionNode;
    }

    @Override
    public boolean isElementVisible(Viewer viewer, Object element) {
        IPreferenceNode node;
        if (WorkbenchActivityHelper.restrictUseOf(element)) {
            return false;
        }
        if (this.isLeafMatch(viewer, element)) {
            return true;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)((TreeViewer)viewer).getContentProvider();
        Object[] children = contentProvider.getChildren((Object)(node = (IPreferenceNode)element));
        return this.filter(viewer, element, children).length > 0;
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object element) {
        IPreferenceNode node = (IPreferenceNode)element;
        String text = node.getLabelText();
        if (this.wordMatches(text)) {
            return true;
        }
        String[] stringArray = this.getKeywords(node);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (this.wordMatches(keyword)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

