/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IdentifierChangeListener;
import org.tmdmaker.core.model.RelatedRelationship;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.SubsetType;
import org.tmdmaker.core.model.parts.ModelName;

public class SubsetType2SubsetRelationship
extends RelatedRelationship
implements IdentifierChangeListener {
    public SubsetType2SubsetRelationship(SubsetType subsetType, ModelName subsetName) {
        super(subsetType, SubsetEntity.build(subsetType.getSuperset(), subsetName));
    }

    @Override
    public void connect() {
        super.connect();
        Diagram diagram = this.getSubsetType().getSuperset().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.getSubsetEntity());
        }
    }

    @Override
    public void disconnect() {
        Diagram diagram = this.getSubsetType().getSuperset().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.getSubsetEntity());
        }
        super.disconnect();
    }

    public SubsetType getSubsetType() {
        return (SubsetType)this.getSource();
    }

    public SubsetEntity getSubsetEntity() {
        return (SubsetEntity)this.getTarget();
    }

    @Override
    public void identifierChanged() {
        SubsetEntity subset = (SubsetEntity)this.getTarget();
        subset.setOriginalReusedIdentifier(this.getOriginal().createReusedIdentifier());
        subset.fireIdentifierChanged(this);
    }

    private AbstractEntityModel getOriginal() {
        return (AbstractEntityModel)this.getSource().getModelTargetConnections().get(0).getSource();
    }

    @Override
    public String getSourceName() {
        return this.getOriginal().getName();
    }

    @Override
    public String getTargetName() {
        return this.getTarget().getName();
    }
}

