/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.model.DataTypeDeclaration;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.Identifier;

public class IdentifierRef
extends Identifier {
    private Identifier original;
    private Boolean duplicate = null;

    public IdentifierRef(Identifier identifier) {
        this.original = identifier;
    }

    public Identifier getOriginal() {
        return this.original;
    }

    public void setOriginal(Identifier original) {
        this.original = original;
    }

    @Override
    public String getName() {
        String returnName = super.getName();
        if (returnName == null) {
            returnName = this.original.getName();
        }
        return returnName;
    }

    public boolean isSame(IdentifierRef identifierRef) {
        return this.original.equals(identifierRef.getOriginal());
    }

    @Override
    public String getImplementName() {
        String returnName = super.getImplementName();
        if (returnName == null) {
            returnName = this.original.getImplementName();
        }
        return returnName;
    }

    @Override
    public void setImplementName(String implementName) {
        String oldValue = super.getImplementName();
        if (implementName == null || !implementName.equals(oldValue)) {
            super.setImplementName(implementName);
        }
    }

    @Override
    public DataTypeDeclaration getDataTypeDeclaration() {
        DataTypeDeclaration returnValue = super.getDataTypeDeclaration();
        if (returnValue == null) {
            returnValue = this.original.getDataTypeDeclaration();
        }
        return returnValue;
    }

    @Override
    public void copyTo(IAttribute to) {
        to.setDerivationRule(this.getDerivationRule());
        to.setDescription(this.getDescription());
        to.setLock(this.getLock());
        to.setValidationRule(this.getValidationRule());
        if (this.getDataTypeDeclaration() != null) {
            to.setDataTypeDeclaration(this.getDataTypeDeclaration().getCopy());
        } else {
            to.setDataTypeDeclaration(null);
        }
        to.setImplementName(this.getImplementName());
        to.setNullable(this.isNullable());
    }

    public Boolean isDuplicate() {
        if (this.duplicate == null) {
            if (this.original instanceof IdentifierRef) {
                return ((IdentifierRef)this.original).isDuplicate();
            }
            return false;
        }
        return this.duplicate;
    }

    public void setDuplicate(Boolean duplicate) {
        this.duplicate = duplicate;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

