/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.IdentifierChangeListener;
import org.tmdmaker.core.model.RelatedRelationship;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.VirtualSupersetType;

public class Entity2VirtualSupersetTypeRelationship
extends RelatedRelationship
implements IdentifierChangeListener {
    private ReusedIdentifier targetIdentifier;

    public Entity2VirtualSupersetTypeRelationship(AbstractEntityModel source, ConnectableElement target) {
        super(source, target);
    }

    @Override
    public void identifierChanged() {
        VirtualSupersetType type = (VirtualSupersetType)this.getTarget();
        VirtualSuperset superset = type.getSuperset();
        if (superset != null) {
            superset.fireIdentifierChanged(this);
        }
    }

    @Override
    public void attachTarget() {
        super.attachTarget();
        if (this.targetIdentifier == null) {
            ((VirtualSupersetType)this.getTarget()).addReusedIdentifier((AbstractEntityModel)this.getSource());
        } else {
            ((VirtualSupersetType)this.getTarget()).addReusedIdentifier((AbstractEntityModel)this.getSource(), this.targetIdentifier);
            this.targetIdentifier = null;
        }
    }

    @Override
    public void detachTarget() {
        this.targetIdentifier = ((VirtualSupersetType)this.getTarget()).removeReusedIdentifier((AbstractEntityModel)this.getSource());
        super.detachTarget();
    }

    @Override
    public String getSourceName() {
        return this.getTarget().getModelSourceConnections().get(0).getTarget().getName();
    }

    @Override
    public String getTargetName() {
        return this.getSource().getName();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

