/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.core.model.ModelFilter;
import org.tmdmaker.core.model.filter.ExcludeClassFilter;
import org.tmdmaker.core.model.filter.ExcludeModelFilter;
import org.tmdmaker.core.model.filter.ImplementModelFilter;
import org.tmdmaker.core.model.filter.NameMatchFilter;
import org.tmdmaker.core.model.parts.ModelName;

public class DiagramQuery {
    private final Diagram diagram;
    private boolean implementModelOnly = false;
    private ModelName name;
    private List<ModelElement> excludes = new ArrayList<ModelElement>();
    private List<Class<?>> excludeClasses = new ArrayList();

    DiagramQuery(Diagram diagram) {
        this.diagram = diagram;
    }

    public DiagramQuery exclude(ModelElement m) {
        this.excludes.add(m);
        return this;
    }

    public DiagramQuery exclude(List<? extends ModelElement> modelList) {
        this.excludes.addAll(modelList);
        return this;
    }

    public DiagramQuery excludeClass(Class<?> clazz) {
        this.excludeClasses.add(clazz);
        return this;
    }

    public DiagramQuery implementModel() {
        this.implementModelOnly = true;
        return this;
    }

    public DiagramQuery name(ModelName name) {
        this.name = name;
        return this;
    }

    private <T> List<T> listModel(Class<T> clazz) {
        ArrayList<ModelElement> results = new ArrayList<ModelElement>();
        for (ModelElement m : this.diagram.getChildren()) {
            ModelElement filteredModel = this.applyFilteres(m);
            if (filteredModel == null || !clazz.isAssignableFrom(m.getClass())) continue;
            results.add(m);
        }
        return results;
    }

    private ModelElement applyFilteres(ModelElement model) {
        ModelFilter[] modelFilterArray = this.createFilteres();
        int n = modelFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelFilter filter = modelFilterArray[n2];
            ModelElement filteredModel = filter.filter(model);
            if (filteredModel == null) {
                return null;
            }
            ++n2;
        }
        return model;
    }

    private ModelFilter[] createFilteres() {
        ArrayList<ModelFilter> filteres = new ArrayList<ModelFilter>();
        filteres.add(new ImplementModelFilter(this.implementModelOnly));
        filteres.add(new ExcludeModelFilter(this.excludes));
        filteres.add(new ExcludeClassFilter(this.excludeClasses));
        filteres.add(new NameMatchFilter(this.name));
        return filteres.toArray(new ModelFilter[filteres.size()]);
    }

    public List<AbstractEntityModel> listEntityModel() {
        return this.listModel(AbstractEntityModel.class);
    }

    public <T extends ModelElement> List<T> listEntityModel(Class<T> clazz) {
        return this.listModel(clazz);
    }
}

