/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.DiagramQuery;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.ModelElement;

public class Diagram
extends ModelElement {
    private String version;
    private String databaseName;
    private List<ModelElement> children = new ArrayList<ModelElement>();
    public static final String PROPERTY_CHILDREN = "_property_children";
    private List<IAttribute> commonAttributes = new ArrayList<IAttribute>();

    public void addChild(AbstractEntityModel child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            child.setDiagram(this);
            this.firePropertyChange(PROPERTY_CHILDREN, null, child);
        }
    }

    public void addChild(ConnectableElement child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
            this.firePropertyChange(PROPERTY_CHILDREN, null, child);
        }
    }

    public void removeChild(AbstractEntityModel child) {
        child.setDiagram(null);
        this.children.remove(child);
        this.firePropertyChange(PROPERTY_CHILDREN, child, null);
    }

    public void removeChild(ConnectableElement child) {
        this.children.remove(child);
        this.firePropertyChange(PROPERTY_CHILDREN, child, null);
    }

    public List<ModelElement> getChildren() {
        return this.children;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public List<IAttribute> getCommonAttributes() {
        return this.commonAttributes;
    }

    public void setCommonAttributes(List<IAttribute> commonAttributes) {
        this.commonAttributes = commonAttributes;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public DiagramQuery query() {
        return new DiagramQuery(this);
    }

    public boolean contains(ModelElement m) {
        return this.children.contains(m);
    }
}

