/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.treeeditparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.ui.Activator;
import org.tmdmaker.ui.editor.gef3.editparts.IAttributeEditPart;
import org.tmdmaker.ui.editor.gef3.treeeditparts.AbstractEntityModelTreeEditPart;
import org.tmdmaker.ui.util.ModelEditUtils;
import org.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.tmdmaker.ui.views.properties.gef3.IAttributePropertySource;

public class AttributeTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener,
IPropertyAvailable,
IAttributeEditPart {
    private static Logger logger = LoggerFactory.getLogger(AttributeTreeEditPart.class);
    protected EditPolicy componentPolicy;

    public AttributeTreeEditPart(Attribute attribute, EditPolicy policy) {
        this.setModel(attribute);
        this.componentPolicy = policy;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.componentPolicy);
    }

    public Attribute getModel() {
        return (Attribute)super.getModel();
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            Command ccommand = this.getCommand(request);
            this.executeEditCommand(ccommand);
        }
    }

    protected void executeEditCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected String getText() {
        return ModelEditUtils.toBlankStringIfNull(this.getModel().getName());
    }

    protected Image getImage() {
        return Activator.getImage("icons/outline/attribute.png");
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug("{}.{}", this.getClass(), (Object)evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.refreshVisuals();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    @Override
    public IPropertySource getPropertySource(CommandStack commandStack) {
        return new IAttributePropertySource(commandStack, (IAttribute)this.getModel());
    }

    @Override
    public AbstractEntityModel getParentModel() {
        EditPart part = this.getParent().getParent();
        if (part instanceof AbstractEntityModelTreeEditPart) {
            return (AbstractEntityModel)part.getModel();
        }
        return (AbstractEntityModel)part.getParent().getModel();
    }
}

