/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editparts.node;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.other.Memo;
import org.tmdmaker.ui.editor.draw2d.figure.node.MemoFigure;
import org.tmdmaker.ui.editor.gef3.commands.MemoChangeCommand;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;

public class MemoEditPart
extends AbstractModelEditPart<Memo> {
    public MemoEditPart(Memo model) {
        this.setModel(model);
    }

    protected IFigure createFigure() {
        this.logger.debug("{}#createFigure()", this.getClass());
        return new MemoFigure();
    }

    @Override
    protected void updateFigure(IFigure figure) {
        this.logger.debug("{}#updateFigure()", this.getClass());
        MemoFigure memoFigure = (MemoFigure)this.getFigure();
        Memo memo = (Memo)this.getModel();
        memoFigure.setMemo(memo.getMemo());
        memoFigure.setupColor();
    }

    @Override
    public void performRequest(Request request) {
        this.logger.debug("{} {}", this.getClass(), request.getType());
        if ("open".equals(request.getType())) {
            this.onDirectEdit();
        } else if ("direct edit".equals(request.getType())) {
            this.onDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    @Override
    protected void onDirectEdit() {
        this.logger.debug("{}#onDirectEdit()", this.getClass());
        MemoFigure figure = (MemoFigure)this.getFigure();
        TextFlow label = figure.getMemoTextFlow();
        MemoDirectEditManager manager = new MemoDirectEditManager((GraphicalEditPart)this, label);
        manager.show();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.logger.debug("{}#propertyChange() {}", this.getClass(), (Object)evt.getPropertyName());
        if (evt.getPropertyName().equals("p_memo")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new MemoDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MemoDeleteEditPolicy());
    }

    @Override
    public boolean canAutoSize() {
        return ((MemoFigure)this.getFigure()).canAutoSize();
    }

    @Override
    public boolean canCallSelectionAction() {
        return false;
    }

    private static class Locator
    implements CellEditorLocator {
        private TextFlow label;

        public Locator(TextFlow label) {
            this.label = label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Point pref = text.computeSize(-1, -1);
            Rectangle rect = this.label.getBounds().getCopy();
            this.label.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x - 1, rect.y - 1, pref.x + 1, pref.y + 1);
        }
    }

    private static class MemoDeleteCommand
    extends Command {
        private Diagram diagram;
        private Memo memo;

        public MemoDeleteCommand(Diagram diagram, Memo memo) {
            this.diagram = diagram;
            this.memo = memo;
        }

        public void execute() {
            this.diagram.removeChild((ConnectableElement)this.memo);
        }

        public void undo() {
            this.diagram.addChild((ConnectableElement)this.memo);
        }
    }

    private static class MemoDeleteEditPolicy
    extends ComponentEditPolicy {
        private MemoDeleteEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            return new MemoDeleteCommand((Diagram)this.getHost().getParent().getModel(), (Memo)this.getHost().getModel());
        }
    }

    private static class MemoDirectEditManager
    extends DirectEditManager {
        public MemoDirectEditManager(GraphicalEditPart source, TextFlow label) {
            super(source, TextCellEditor.class, (CellEditorLocator)new Locator(label), (Object)label);
        }

        protected CellEditor createCellEditorOn(Composite composite) {
            return new TextCellEditor(composite, 66);
        }

        protected void initCellEditor() {
            TextFlow label = (TextFlow)this.getDirectEditFeature();
            String initialLabelText = label.getText();
            this.getCellEditor().setValue((Object)initialLabelText);
        }
    }

    private static class MemoDirectEditPolicy
    extends DirectEditPolicy {
        private MemoDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            String newValue = (String)request.getCellEditor().getValue();
            Memo memo = (Memo)this.getHost().getModel();
            return new MemoChangeCommand(memo, newValue);
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            MemoFigure figure = (MemoFigure)this.getHostFigure();
            String value = (String)request.getCellEditor().getValue();
            figure.setMemo(value);
        }
    }
}

