/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.commands;

import org.eclipse.gef.commands.Command;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractRelationship;
import org.tmdmaker.core.model.Cardinality;
import org.tmdmaker.ui.editor.draw2d.ConstraintAdjuster;
import org.tmdmaker.ui.editor.draw2d.ConstraintAdjusterFactory;

public class RelationshipEditCommand
extends Command {
    private AbstractRelationship model;
    private Cardinality sourceCardinality = Cardinality.ONE;
    private Cardinality targetCardinality = Cardinality.ONE;
    private boolean sourceNoInstance = false;
    private boolean targetNoInstance = false;
    private Cardinality oldSourceCardinality = null;
    private Cardinality oldTargetCardinality = null;
    private boolean oldSourceNoInstance = false;
    private boolean oldTargetNoInstance = false;

    public void execute() {
        this.model.setSourceNoInstance(this.sourceNoInstance);
        this.model.setSourceCardinality(this.sourceCardinality);
        this.model.setTargetNoInstance(this.targetNoInstance);
        this.model.setTargetCardinality(this.targetCardinality);
        ConstraintAdjuster adjuster = ConstraintAdjusterFactory.getAdjuster((AbstractConnectionModel)this.model);
        adjuster.adjust();
    }

    public void undo() {
        this.model.setSourceNoInstance(this.oldSourceNoInstance);
        this.model.setSourceCardinality(this.oldSourceCardinality);
        this.model.setTargetNoInstance(this.oldTargetNoInstance);
        this.model.setTargetCardinality(this.oldTargetCardinality);
    }

    public void setModel(AbstractRelationship model) {
        this.model = model;
        this.oldSourceCardinality = model.getSourceCardinality();
        this.oldSourceNoInstance = model.isSourceNoInstance();
        this.oldTargetCardinality = model.getTargetCardinality();
        this.oldTargetNoInstance = model.isTargetNoInstance();
    }

    public void setSourceCardinality(Cardinality sourceCardinality) {
        this.sourceCardinality = sourceCardinality;
    }

    public void setTargetCardinality(Cardinality targetCardinality) {
        this.targetCardinality = targetCardinality;
    }

    public void setSourceNoInstance(boolean sourceNoInstance) {
        this.sourceNoInstance = sourceNoInstance;
    }

    public void setTargetNoInstance(boolean targetNoInstance) {
        this.targetNoInstance = targetNoInstance;
    }
}

