/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.ui.Activator;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.GeneratorDialog;
import org.tmdmaker.ui.editor.TMDEditor;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import org.tmdmaker.ui.editor.workspace.Workspace;

public class GenerateAction
extends SelectionAction {
    private Generator generator;
    private GraphicalViewer viewer;

    public GenerateAction(TMDEditor editor, GraphicalViewer viewer, Generator generator) {
        super((IWorkbenchPart)editor);
        this.generator = generator;
        this.viewer = viewer;
        this.setId(generator.getClass().getName());
        this.setText(generator.getGeneratorName());
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        Diagram diagram = (Diagram)this.viewer.getContents().getModel();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        GeneratorDialog dialog = new GeneratorDialog(this.getWorkbenchPart().getSite().getShell(), this.getSavePath(), this.generator.getGeneratorName(), selectedModels, this.getNotSelectedModelList(diagram, selectedModels));
        if (dialog.open() == 0) {
            try {
                String savePath = dialog.getSavePath();
                this.generator.execute(savePath, dialog.getSelectedModels());
                Activator.showMessageDialog(String.valueOf(this.generator.getGeneratorName()) + Messages.Completion);
                new Workspace().refreshGenerateResources(savePath);
            }
            catch (Throwable t) {
                Activator.showErrorDialog(t);
            }
        }
    }

    private String getSavePath() {
        IFile file = new Workspace().getEditFile(this.getWorkbenchPart());
        return file.getLocation().removeLastSegments(1).toOSString();
    }

    private List<AbstractEntityModel> getSelectedModelList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Object selection : this.getSelectedObjects()) {
            Object obj;
            if (!(selection instanceof AbstractModelEditPart) || !((obj = ((AbstractModelEditPart)selection).getModel()) instanceof AbstractEntityModel)) continue;
            AbstractEntityModel model = (AbstractEntityModel)obj;
            if (this.generator.isImplementModelOnly()) {
                if (model.isNotImplement()) continue;
                list.add(model);
                continue;
            }
            list.add(model);
        }
        return list;
    }

    private List<AbstractEntityModel> getNotSelectedModelList(Diagram diagram, List<AbstractEntityModel> selectedModels) {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        list.removeAll(selectedModels);
        if (this.generator.isImplementModelOnly()) {
            list.addAll(diagram.query().implementModel().listEntityModel());
        } else {
            list.addAll(diagram.query().listEntityModel());
        }
        list.removeAll(selectedModels);
        return list;
    }
}

