/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IWorkbenchPart;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.actions.gef3.AbstractMultipleSelectionAction;
import org.tmdmaker.ui.editor.draw2d.ConstraintConverter;
import org.tmdmaker.ui.editor.gef3.commands.ConstraintChangeCommand;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;

public class AutoSizeSettingAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "AutoSizeSettingAction";

    public AutoSizeSettingAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.AutomaticSizeAdjustment);
        this.setId(ID);
    }

    public void run() {
        CompoundCommand ccommand = new CompoundCommand();
        for (ConnectableElement m : this.getSelectedElementList()) {
            ccommand.add((Command)new ConstraintChangeCommand((ModelElement)m, ConstraintConverter.getResetRectangle((ModelElement)m)));
        }
        if (!ccommand.isEmpty()) {
            this.execute(ccommand.unwrap());
        }
    }

    @Override
    protected boolean isTargetModel(Object selection) {
        if (selection instanceof AbstractModelEditPart) {
            return this.getPart().canAutoSize();
        }
        return false;
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getSelectedElementList().size() >= 1;
    }

    protected List<ConnectableElement> getSelectedElementList() {
        ArrayList<ConnectableElement> list = new ArrayList<ConnectableElement>();
        for (Object selection : this.getSelectedObjects()) {
            Object model;
            if (!this.isTargetModel(selection) || !((model = this.getPart().getModel()) instanceof ConnectableElement)) continue;
            list.add((ConnectableElement)model);
        }
        return list;
    }
}

