/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.components;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditSubsetEntity;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SubsetSettingPanel
extends Composite {
    private static int EDIT_COLUMN = 0;
    private int selectedIndex = -1;
    private TableEditor tableEditor = null;
    private boolean exceptNull = false;
    private boolean sameType = false;
    private List<EditSubsetEntity> deletedSubsetEntityList = new ArrayList<EditSubsetEntity>();
    private List<EditSubsetEntity> subsetEntityList = null;
    private Label partitionCodeLabel = null;
    private Combo partitionSelectCombo = null;
    private Group typeGroup = null;
    private Button sameRadioButton = null;
    private Button differenceRadioButton = null;
    private Button nullCheckBox = null;
    private Composite subsetContainerComposite = null;
    private Table subsetTable = null;
    private Composite subsetControlComposite = null;
    private Button newButton = null;
    private Button deleteButton = null;

    public SubsetSettingPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.partitionCodeLabel = new Label((Composite)this, 0);
        this.partitionCodeLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.partitionCodeLabel.setText(Messages.PartitionCode);
        this.setLayout((Layout)gridLayout);
        this.createPartitionSelectCombo();
        this.createTypeGroup();
        this.createSubsetContainerComposite();
        this.setSize(new Point(300, 208));
    }

    private void createPartitionSelectCombo() {
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.widthHint = 172;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 0x1000000;
        this.partitionSelectCombo = new Combo((Composite)this, 0);
        this.partitionSelectCombo.setLayoutData((Object)gridData3);
    }

    private void createTypeGroup() {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.typeGroup = new Group((Composite)this, 0);
        this.typeGroup.setText(Messages.SubsetType);
        this.typeGroup.setLayout((Layout)new FillLayout(256));
        this.typeGroup.setLayoutData((Object)gridData);
        this.sameRadioButton = new Button((Composite)this.typeGroup, 16);
        this.sameRadioButton.setText(Messages.SubsetTypeHometype);
        this.sameRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubsetSettingPanel.this.sameType = true;
                SubsetSettingPanel.this.exceptNull = false;
                SubsetSettingPanel.this.nullCheckBox.setSelection(false);
                SubsetSettingPanel.this.nullCheckBox.setEnabled(false);
            }
        });
        this.differenceRadioButton = new Button((Composite)this.typeGroup, 16);
        this.differenceRadioButton.setText(Messages.SubsetTypeHeterotypic);
        this.differenceRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubsetSettingPanel.this.sameType = false;
                SubsetSettingPanel.this.nullCheckBox.setEnabled(true);
            }
        });
        this.nullCheckBox = new Button((Composite)this.typeGroup, 32);
        this.nullCheckBox.setText(Messages.SubsetTypeExcludeNull);
        this.nullCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubsetSettingPanel.this.exceptNull = !SubsetSettingPanel.this.exceptNull;
            }
        });
    }

    private void createSubsetContainerComposite() {
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.heightHint = 88;
        gridData2.widthHint = 136;
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 4;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        GridData gridData1 = new GridData();
        gridData1.widthHint = 237;
        gridData1.horizontalSpan = 2;
        gridData1.verticalAlignment = 4;
        gridData1.horizontalAlignment = 4;
        this.subsetContainerComposite = new Composite((Composite)this, 0);
        this.subsetContainerComposite.setLayoutData((Object)gridData1);
        this.subsetContainerComposite.setLayout((Layout)gridLayout2);
        this.subsetTable = new Table(this.subsetContainerComposite, 0);
        this.subsetTable.setHeaderVisible(true);
        this.subsetTable.setLayoutData((Object)gridData2);
        this.subsetTable.setLinesVisible(true);
        this.subsetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubsetSettingPanel.this.selectedIndex = SubsetSettingPanel.this.subsetTable.getSelectionIndex();
                if (SubsetSettingPanel.this.selectedIndex == -1) {
                    return;
                }
                Control oldEditor = SubsetSettingPanel.this.tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                TableItem item = (TableItem)e.item;
                final Text text = new Text((Composite)SubsetSettingPanel.this.subsetTable, 0);
                text.setText(item.getText(EDIT_COLUMN));
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TableItem item = SubsetSettingPanel.this.tableEditor.getItem();
                        if (item != null) {
                            if (item.isDisposed()) {
                                return;
                            }
                            String editValue = text.getText();
                            if (editValue == null) {
                                editValue = "";
                            }
                            item.setText(EDIT_COLUMN, editValue);
                            EditSubsetEntity ese = (EditSubsetEntity)SubsetSettingPanel.this.subsetEntityList.get(SubsetSettingPanel.this.selectedIndex);
                            ese.setName(editValue);
                        }
                        text.dispose();
                    }
                });
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        TableItem item = SubsetSettingPanel.this.tableEditor.getItem();
                        String editValue = text.getText();
                        if (editValue == null) {
                            editValue = "";
                        }
                        item.setText(EDIT_COLUMN, editValue);
                        EditSubsetEntity ese = (EditSubsetEntity)SubsetSettingPanel.this.subsetEntityList.get(SubsetSettingPanel.this.selectedIndex);
                        ese.setName(editValue);
                    }
                });
                text.selectAll();
                text.setFocus();
                SubsetSettingPanel.this.tableEditor.setEditor((Control)text, item, EDIT_COLUMN);
            }
        });
        this.createSubsetControlComposite();
        TableColumn tableColumn = new TableColumn(this.subsetTable, 0);
        tableColumn.setWidth(120);
        tableColumn.setText(Messages.SubsetName);
        this.tableEditor = new TableEditor(this.subsetTable);
        this.tableEditor.grabHorizontal = true;
        this.tableEditor.horizontalAlignment = 16384;
        this.tableEditor.minimumWidth = 50;
    }

    private void createSubsetControlComposite() {
        this.subsetControlComposite = new Composite(this.subsetContainerComposite, 0);
        GridData gd_subsetControlComposite = new GridData(4, 4, false, false, 1, 1);
        gd_subsetControlComposite.widthHint = 76;
        this.subsetControlComposite.setLayoutData((Object)gd_subsetControlComposite);
        this.subsetControlComposite.setLayout((Layout)new GridLayout());
        this.newButton = new Button(this.subsetControlComposite, 0);
        this.newButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.newButton.setText(Messages.AddButton);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditSubsetEntity ese = new EditSubsetEntity();
                ese.setName(String.valueOf(Messages.Subset) + String.valueOf(SubsetSettingPanel.this.subsetEntityList.size() + 1));
                SubsetSettingPanel.this.subsetEntityList.add(ese);
                SubsetSettingPanel.this.selectedIndex = SubsetSettingPanel.this.subsetEntityList.size() - 1;
                SubsetSettingPanel.this.updateTable();
                SubsetSettingPanel.this.updateSelection();
            }
        });
        this.deleteButton = new Button(this.subsetControlComposite, 0);
        this.deleteButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.deleteButton.setText(Messages.RemoveButton);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SubsetSettingPanel.this.selectedIndex == -1) {
                    return;
                }
                Control oldEditor = SubsetSettingPanel.this.tableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                EditSubsetEntity deleted = (EditSubsetEntity)SubsetSettingPanel.this.subsetEntityList.remove(SubsetSettingPanel.this.selectedIndex);
                SubsetSettingPanel.this.deletedSubsetEntityList.add(deleted);
                if (SubsetSettingPanel.this.subsetEntityList.size() <= SubsetSettingPanel.this.selectedIndex) {
                    SubsetSettingPanel subsetSettingPanel = SubsetSettingPanel.this;
                    subsetSettingPanel.selectedIndex = subsetSettingPanel.selectedIndex - 1;
                }
                SubsetSettingPanel.this.updateTable();
                SubsetSettingPanel.this.updateSelection();
            }
        });
    }

    public void initializeValue(boolean sameType, boolean exceptNull, List<IAttribute> attributes, List<EditSubsetEntity> subsets, IAttribute selectedAttribute) {
        this.sameType = sameType;
        this.exceptNull = exceptNull;
        if (sameType) {
            this.sameRadioButton.setSelection(true);
            this.nullCheckBox.setEnabled(false);
        } else {
            this.differenceRadioButton.setSelection(true);
            this.nullCheckBox.setSelection(exceptNull);
        }
        for (IAttribute a : attributes) {
            this.partitionSelectCombo.add(a.getName());
            if (!a.equals(selectedAttribute)) continue;
            this.partitionSelectCombo.select(this.partitionSelectCombo.getItemCount() - 1);
        }
        this.subsetEntityList = subsets;
        for (EditSubsetEntity se : subsets) {
            TableItem item = new TableItem(this.subsetTable, 0);
            item.setText(se.getName());
        }
    }

    private void updateTable() {
        this.subsetTable.removeAll();
        for (EditSubsetEntity ese : this.subsetEntityList) {
            TableItem item = new TableItem(this.subsetTable, 0);
            item.setText(ese.getName());
        }
    }

    private void updateSelection() {
        this.subsetTable.select(this.selectedIndex);
    }

    public boolean isSameTypeSelected() {
        return this.sameType;
    }

    public int getSelectedPartitionAttributeIndex() {
        return this.partitionSelectCombo.getSelectionIndex();
    }

    public List<EditSubsetEntity> getSubsetEntityList() {
        return this.subsetEntityList;
    }

    public boolean isExceptNull() {
        return this.exceptNull;
    }

    public List<EditSubsetEntity> getDeletedSubsetEntityList() {
        return this.deletedSubsetEntityList;
    }
}

