/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.csv.attributelist;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.csv.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.generate.attributelist.AttributeListModelBuilder;
import jp.sourceforge.tmdmaker.model.generate.attributelist.EntityAttributePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeListCsvGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(AttributeListCsvGenerator.class);
    private static final String[] TITLES = new String[]{Messages.getString("AttributeListCsvGenerator.AttributeName"), Messages.getString("AttributeListCsvGenerator.Entity"), Messages.getString("AttributeListCsvGenerator.Summary"), Messages.getString("AttributeListCsvGenerator.Premise"), Messages.getString("AttributeListCsvGenerator.Confidentiality"), Messages.getString("AttributeListCsvGenerator.Formula")};

    public String getGroupName() {
        return "CSV";
    }

    public String getGeneratorName() {
        return Messages.getString("AttributeListCsvGenerator.GeneratorName");
    }

    public boolean isImplementModelOnly() {
        return false;
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        block14: {
            if (models.isEmpty()) {
                return;
            }
            Map attributes = new AttributeListModelBuilder().build(models);
            File file = new File(rootDir, "attribute_list.csv");
            CSVWriter writer = null;
            try {
                try {
                    writer = new CSVWriter((Writer)new FileWriter(file));
                    writer.writeNext(TITLES);
                    String[] rowData = new String[TITLES.length];
                    for (EntityAttributePair pair : attributes.values()) {
                        IAttribute attribute = pair.getAttribute();
                        rowData[0] = attribute.getName();
                        rowData[1] = pair.getModel().getName();
                        rowData[2] = attribute.getDescription();
                        rowData[3] = attribute.getValidationRule();
                        rowData[4] = attribute.getLock();
                        rowData[5] = attribute.getDerivationRule();
                        writer.writeNext(rowData);
                    }
                    writer.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    if (writer == null) break block14;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        logger.warn(e2.getMessage());
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        logger.warn(e.getMessage());
                    }
                }
            }
        }
    }
}

