/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructorProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Beta
public class AccessorsProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, final @Extension TransformationContext context) {
        Consumer<MutableMemberDeclaration> _function = new Consumer<MutableMemberDeclaration>(){

            @Override
            public void accept(MutableMemberDeclaration it) {
                AccessorsProcessor.this.transform(it, context);
            }
        };
        elements.forEach(_function);
    }

    protected void _transform(MutableFieldDeclaration it, @Extension TransformationContext context) {
        boolean _shouldAddSetter;
        Util util = new Util(context);
        boolean _shouldAddGetter = util.shouldAddGetter((FieldDeclaration)it);
        if (_shouldAddGetter) {
            util.addGetter(it, util.toVisibility(util.getGetterType((FieldDeclaration)it)));
        }
        if (_shouldAddSetter = util.shouldAddSetter((FieldDeclaration)it)) {
            util.addSetter(it, util.toVisibility(util.getSetterType((FieldDeclaration)it)));
        }
    }

    protected void _transform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        FinalFieldsConstructorProcessor.Util requiredArgsUtil = new FinalFieldsConstructorProcessor.Util(context);
        if (requiredArgsUtil.needsFinalFieldConstructor(it) || it.findAnnotation(context.findTypeGlobally(FinalFieldsConstructor.class)) != null) {
            requiredArgsUtil.addFinalFieldsConstructor(it);
        }
        Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration it) {
                return !it.isStatic() && context.isThePrimaryGeneratedJavaElement((Element)it);
            }
        };
        Consumer<MutableFieldDeclaration> _function_1 = new Consumer<MutableFieldDeclaration>(){

            @Override
            public void accept(MutableFieldDeclaration it) {
                AccessorsProcessor.this._transform(it, context);
            }
        };
        IterableExtensions.filter((Iterable)it.getDeclaredFields(), (Functions.Function1)_function).forEach(_function_1);
    }

    public void transform(MutableMemberDeclaration it, TransformationContext context) {
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        if (it instanceof MutableFieldDeclaration) {
            this._transform((MutableFieldDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Visibility toVisibility(AccessorType type) {
            Visibility _switchResult = null;
            if (type != null) {
                switch (type) {
                    case PUBLIC_GETTER: {
                        _switchResult = Visibility.PUBLIC;
                        break;
                    }
                    case PROTECTED_GETTER: {
                        _switchResult = Visibility.PROTECTED;
                        break;
                    }
                    case PACKAGE_GETTER: {
                        _switchResult = Visibility.DEFAULT;
                        break;
                    }
                    case PRIVATE_GETTER: {
                        _switchResult = Visibility.PRIVATE;
                        break;
                    }
                    case PUBLIC_SETTER: {
                        _switchResult = Visibility.PUBLIC;
                        break;
                    }
                    case PROTECTED_SETTER: {
                        _switchResult = Visibility.PROTECTED;
                        break;
                    }
                    case PACKAGE_SETTER: {
                        _switchResult = Visibility.DEFAULT;
                        break;
                    }
                    case PRIVATE_SETTER: {
                        _switchResult = Visibility.PRIVATE;
                        break;
                    }
                    default: {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Cannot convert ");
                        _builder.append((Object)type);
                        throw new IllegalArgumentException(_builder.toString());
                    }
                }
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot convert ");
                _builder.append((Object)type);
                throw new IllegalArgumentException(_builder.toString());
            }
            return _switchResult;
        }

        public boolean hasGetter(final FieldDeclaration it) {
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String name) {
                    MethodDeclaration _findDeclaredMethod = it.getDeclaringType().findDeclaredMethod(name, new TypeReference[0]);
                    return _findDeclaredMethod != null;
                }
            };
            return IterableExtensions.exists(this.getPossibleGetterNames(it), (Functions.Function1)_function);
        }

        public boolean shouldAddGetter(FieldDeclaration it) {
            return !this.hasGetter(it) && this.getGetterType(it) != AccessorType.NONE;
        }

        public AccessorType getGetterType(FieldDeclaration it) {
            AnnotationReference _accessorsAnnotation_1;
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            _elvis = _accessorsAnnotation != null ? _accessorsAnnotation : (_accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)it.getDeclaringType()));
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                Functions.Function1<EnumerationValueDeclaration, AccessorType> _function = new Functions.Function1<EnumerationValueDeclaration, AccessorType>(){

                    public AccessorType apply(EnumerationValueDeclaration it) {
                        return AccessorType.valueOf(it.getSimpleName());
                    }
                };
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)annotation.getEnumArrayValue("value"))), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1<AccessorType, Boolean> _function_1 = new Functions.Function1<AccessorType, Boolean>(){

                    public Boolean apply(AccessorType it) {
                        return it.name().endsWith("GETTER");
                    }
                };
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        public AnnotationReference getAccessorsAnnotation(AnnotationTarget it) {
            return it.findAnnotation(this.context.findTypeGlobally(Accessors.class));
        }

        public Object validateGetter(MutableFieldDeclaration field) {
            return null;
        }

        public String getGetterName(FieldDeclaration it) {
            return (String)IterableExtensions.head(this.getPossibleGetterNames(it));
        }

        public List<String> getPossibleGetterNames(final FieldDeclaration it) {
            ArrayList names = CollectionLiterals.newArrayList((Object[])new String[0]);
            if (this.isBooleanType(this.orObject(it.getType())) && it.getSimpleName().startsWith("is") && it.getSimpleName().length() > 2 && Character.isUpperCase(it.getSimpleName().charAt(2))) {
                String _simpleName = it.getSimpleName();
                names.add(_simpleName);
            }
            List _xifexpression = null;
            boolean _isBooleanType = this.isBooleanType(this.orObject(it.getType()));
            _xifexpression = _isBooleanType ? Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"is", "get"})) : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"get"}));
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String prefix) {
                    String _firstUpper = StringExtensions.toFirstUpper((String)it.getSimpleName());
                    return prefix + _firstUpper;
                }
            };
            names.addAll(ListExtensions.map(_xifexpression, (Functions.Function1)_function));
            return names;
        }

        public boolean isBooleanType(TypeReference it) {
            return !it.isInferred() && Objects.equal((Object)it, (Object)this.context.getPrimitiveBoolean());
        }

        public void addGetter(final MutableFieldDeclaration field, final Visibility visibility) {
            this.validateGetter(field);
            field.markAsRead();
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement((MutableElement)it, Util.this.context.getPrimarySourceElement((Element)field));
                    it.addAnnotation(Util.this.context.newAnnotationReference(Pure.class));
                    it.setReturnType(Util.this.orObject(field.getType()));
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"return ");
                            Object _fieldOwner = Util.this.fieldOwner(field);
                            _builder.append(_fieldOwner);
                            _builder.append((Object)".");
                            String _simpleName = field.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)";");
                        }
                    };
                    it.setBody(_client);
                    it.setStatic(field.isStatic());
                    it.setVisibility(visibility);
                }
            };
            field.getDeclaringType().addMethod(this.getGetterName((FieldDeclaration)field), (Procedures.Procedure1)_function);
        }

        public AccessorType getSetterType(FieldDeclaration it) {
            AnnotationReference _accessorsAnnotation_1;
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            _elvis = _accessorsAnnotation != null ? _accessorsAnnotation : (_accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)it.getDeclaringType()));
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                Functions.Function1<EnumerationValueDeclaration, AccessorType> _function = new Functions.Function1<EnumerationValueDeclaration, AccessorType>(){

                    public AccessorType apply(EnumerationValueDeclaration it) {
                        return AccessorType.valueOf(it.getSimpleName());
                    }
                };
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)annotation.getEnumArrayValue("value"))), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1<AccessorType, Boolean> _function_1 = new Functions.Function1<AccessorType, Boolean>(){

                    public Boolean apply(AccessorType it) {
                        return it.name().endsWith("SETTER");
                    }
                };
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        private Object fieldOwner(MutableFieldDeclaration it) {
            String _xifexpression = null;
            boolean _isStatic = it.isStatic();
            _xifexpression = _isStatic ? this.context.newTypeReference((Type)it.getDeclaringType(), new TypeReference[0]) : "this";
            return _xifexpression;
        }

        public boolean hasSetter(FieldDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.getDeclaringType().findDeclaredMethod(this.getSetterName(it), new TypeReference[]{this.orObject(it.getType())});
            return _findDeclaredMethod != null;
        }

        public String getSetterName(FieldDeclaration it) {
            String _firstUpper = StringExtensions.toFirstUpper((String)it.getSimpleName());
            return "set" + _firstUpper;
        }

        public boolean shouldAddSetter(FieldDeclaration it) {
            return !it.isFinal() && !this.hasSetter(it) && this.getSetterType(it) != AccessorType.NONE;
        }

        public void validateSetter(MutableFieldDeclaration field) {
            boolean _isFinal = field.isFinal();
            if (_isFinal) {
                this.context.addError((Element)field, "Cannot set a final field");
            }
            if (field.getType() == null || field.getType().isInferred()) {
                this.context.addError((Element)field, "Type cannot be inferred.");
                return;
            }
        }

        public void addSetter(final MutableFieldDeclaration field, final Visibility visibility) {
            this.validateSetter(field);
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Util.this.context.setPrimarySourceElement((MutableElement)it, Util.this.context.getPrimarySourceElement((Element)field));
                    it.setReturnType(Util.this.context.getPrimitiveVoid());
                    final MutableParameterDeclaration param = it.addParameter(field.getSimpleName(), Util.this.orObject(field.getType()));
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            Object _fieldOwner = Util.this.fieldOwner(field);
                            _builder.append(_fieldOwner);
                            _builder.append((Object)".");
                            String _simpleName = field.getSimpleName();
                            _builder.append((Object)_simpleName);
                            _builder.append((Object)" = ");
                            String _simpleName_1 = param.getSimpleName();
                            _builder.append((Object)_simpleName_1);
                            _builder.append((Object)";");
                        }
                    };
                    it.setBody(_client);
                    it.setStatic(field.isStatic());
                    it.setVisibility(visibility);
                }
            };
            field.getDeclaringType().addMethod(this.getSetterName((FieldDeclaration)field), (Procedures.Procedure1)_function);
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

