/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.persistence;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import jp.sourceforge.tmdmaker.extension.PluginExtensionPointFactory;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.persistence.SerializationException;
import jp.sourceforge.tmdmaker.model.persistence.Serializer;
import jp.sourceforge.tmdmaker.persistence.handler.SerializerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamSerializer
implements Serializer {
    private static final String ENCODING = "UTF-8";
    private static Logger logger = LoggerFactory.getLogger(XStreamSerializer.class);
    private PluginExtensionPointFactory<SerializerHandler> factory = new PluginExtensionPointFactory("tmdmaker.serializer.handler");

    public InputStream serialize(Diagram obj) {
        try {
            Diagram before = this.fireBeforeSerialize(obj);
            return this.serializeAsStream(before, before.getClass().getClassLoader());
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(e.getMessage());
            throw new SerializationException((Throwable)e);
        }
    }

    private InputStream serializeAsStream(Object obj, ClassLoader loader) throws UnsupportedEncodingException {
        String xml = this.serializeAsString(obj, loader);
        return new ByteArrayInputStream(xml.getBytes(ENCODING));
    }

    private String serializeAsString(Object obj, ClassLoader loader) {
        XStream xstream = new XStream();
        xstream.setClassLoader(loader);
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + xstream.toXML(obj);
        return this.fireAfterSerialize(result);
    }

    public Diagram deserialize(InputStream in) {
        try {
            String xml = this.loadStream(in, ENCODING);
            logger.debug(this.getVersionFromXml(xml));
            String converted = this.fireBeforeDeserialize(xml);
            Diagram diagram = (Diagram)this.deserialize(new ByteArrayInputStream(converted.getBytes(ENCODING)), this.getClass().getClassLoader());
            this.fireAfterDeserialize(diagram);
            return diagram;
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(e.getMessage());
            throw new SerializationException((Throwable)e);
        }
    }

    private Diagram fireBeforeSerialize(Diagram diagram) {
        for (SerializerHandler c : this.factory.getInstances()) {
            c.handleBeforeSerialize(diagram);
        }
        return diagram;
    }

    private String fireAfterSerialize(String in) {
        String converted = in;
        for (SerializerHandler c : this.factory.getInstances()) {
            converted = c.handleAfterSerialize(converted);
        }
        return converted;
    }

    private String fireBeforeDeserialize(String xml) {
        String converted = xml;
        for (SerializerHandler c : this.factory.getInstances()) {
            converted = c.handleBeforeDeserialize(converted);
        }
        return converted;
    }

    private void fireAfterDeserialize(Diagram diagram) {
        for (SerializerHandler c : this.factory.getInstances()) {
            c.handleAfterDeserialize(diagram);
        }
    }

    private String getVersionFromXml(String xml) {
        if (xml == null || xml.length() == 0) {
            return "";
        }
        if (xml.indexOf("<version>") == -1) {
            return "";
        }
        return xml.substring(xml.indexOf("<version>") + "<version>".length(), xml.indexOf("</version>"));
    }

    private Object deserialize(InputStream in, ClassLoader loader) throws UnsupportedEncodingException {
        XStream xstream = new XStream();
        xstream.setClassLoader(loader);
        return xstream.fromXML((Reader)new InputStreamReader(in, ENCODING));
    }

    private String loadStream(InputStream in, String encoding) {
        try {
            byte[] buf = new byte[in.available()];
            in.read(buf);
            String string = new String(buf, encoding);
            return string;
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            throw new SerializationException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.warn(e.getMessage());
            }
        }
    }
}

