/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.sphinx.keydefinitionlist;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.KeyModels;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.sphinx.keydefinitionlist.KeyDefinitionMapping;
import jp.sourceforge.tmdmaker.sphinx.utilities.SphinxUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class KeyDefinitionListRstGenerator {
    public static void generateKeyDefinitionList(List<AbstractEntityModel> models, File outputdir) {
        final File keysDir = new File(outputdir, "keys");
        keysDir.mkdirs();
        CharSequence _keyList = KeyDefinitionListRstGenerator.keyList(models);
        File _file = new File(outputdir, "key_list.rst");
        SphinxUtils.writeTo(_keyList, _file);
        Consumer<AbstractEntityModel> _function = new Consumer<AbstractEntityModel>(){

            @Override
            public void accept(AbstractEntityModel m) {
                Functions.Function1<IAttribute, Map<String, String>> _function = new Functions.Function1<IAttribute, Map<String, String>>(){

                    public Map<String, String> apply(IAttribute a) {
                        String _name = a.getName();
                        Pair _mappedTo = Pair.of((Object)"name", (Object)_name);
                        String _implementName = a.getImplementName();
                        Pair _mappedTo_1 = Pair.of((Object)"implementName", (Object)_implementName);
                        String _string = KeyDefinitionListRstGenerator.datatype(a.getDataTypeDeclaration()).toString();
                        Pair _mappedTo_2 = Pair.of((Object)"type", (Object)_string);
                        String _nullable = KeyDefinitionListRstGenerator.nullable(a.isNullable());
                        Pair _mappedTo_3 = Pair.of((Object)"null", (Object)_nullable);
                        return Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3}));
                    }
                };
                CharSequence _keys = KeyDefinitionListRstGenerator.keys(m, ListExtensions.map((List)ImplementRule.findAllImplementAttributes((AbstractEntityModel)m), (Functions.Function1)_function));
                String _implementName = m.getImplementName();
                String _plus = String.valueOf(_implementName) + ".rst";
                File _file = new File(keysDir, _plus);
                SphinxUtils.writeTo(_keys, _file);
            }
        };
        models.forEach(_function);
    }

    private static CharSequence datatype(DataTypeDeclaration t) {
        String _xifexpression = null;
        Integer _size = t.getSize();
        boolean _equals = Objects.equal((Object)_size, null);
        if (_equals) {
            _xifexpression = t.getLogicalType().getName();
        } else {
            StringConcatenation _xifexpression_1 = null;
            Integer _scale = t.getScale();
            boolean _equals_1 = Objects.equal((Object)_scale, null);
            if (_equals_1) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = t.getLogicalType().getName();
                _builder.append(_name);
                _builder.append("(");
                Integer _size_1 = t.getSize();
                _builder.append((Object)_size_1);
                _builder.append(")");
                _xifexpression_1 = _builder;
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_1 = t.getLogicalType().getName();
                _builder_1.append(_name_1);
                _builder_1.append("(");
                Integer _size_2 = t.getSize();
                _builder_1.append((Object)_size_2);
                _builder_1.append(".");
                Integer _scale_1 = t.getScale();
                _builder_1.append((Object)_scale_1);
                _builder_1.append(")");
                _xifexpression_1 = _builder_1;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static String nullable(boolean n) {
        String _xifexpression = null;
        _xifexpression = n ? "\u8a31\u5bb9" : "\u7981\u6b62";
        return _xifexpression;
    }

    private static LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> createData(final AbstractEntityModel model) {
        LinkedHashMap _xblockexpression = null;
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)model);
        LinkedHashMap data = new LinkedHashMap();
        Functions.Function2<LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>, IAttribute, LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>> _function = new Functions.Function2<LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>, IAttribute, LinkedHashMap<IAttribute, List<KeyDefinitionMapping>>>(){

            public LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> apply(LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> d, final IAttribute a) {
                LinkedHashMap<IAttribute, List<KeyDefinitionMapping>> _xblockexpression = null;
                Functions.Function1<KeyModel, KeyDefinitionMapping> _function = new Functions.Function1<KeyModel, KeyDefinitionMapping>(){

                    public KeyDefinitionMapping apply(KeyModel k) {
                        return new KeyDefinitionMapping(a, k);
                    }
                };
                d.put(a, IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)model.getKeyModels(), (Functions.Function1)_function)));
                _xblockexpression = d;
                return _xblockexpression;
            }
        };
        _xblockexpression = (LinkedHashMap)IterableExtensions.fold((Iterable)attributes, data, (Functions.Function2)_function);
        return _xblockexpression;
    }

    private static CharSequence keyList(List<AbstractEntityModel> entities) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\u30c6\u30fc\u30d6\u30eb\u8a2d\u8a08\u3068\u30ad\u30fc\u306e\u5b9a\u7fa9\u66f8");
        _builder.newLine();
        _builder.append("=============================");
        _builder.newLine();
        _builder.newLine();
        _builder.append(".. toctree::");
        _builder.newLine();
        _builder.append("   ");
        _builder.append(":maxdepth: 1");
        _builder.newLine();
        _builder.newLine();
        for (AbstractEntityModel entity : entities) {
            _builder.append("keys/");
            String _implementName = entity.getImplementName();
            _builder.append(_implementName);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private static CharSequence keys(AbstractEntityModel m, List<Map<String, String>> columns) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        int _length = m.getName().length();
        int _multiply = _length * 2;
        String _repeat = StringUtils.repeat((String)"=", (int)_multiply);
        _builder.append(_repeat);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\u30c6\u30fc\u30d6\u30eb\u8a2d\u8a08");
        _builder.newLine();
        _builder.append("---------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append(".. list-table::");
        _builder.newLine();
        _builder.append("   ");
        _builder.append(":header-rows: 1");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("* - \u5217\u540d");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("- \u5b9f\u88c5\u540d");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("- \u30c7\u30fc\u30bf\u578b");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("- Null");
        _builder.newLine();
        _builder.newLine();
        for (Map<String, String> c : columns) {
            _builder.append("   ");
            _builder.append("* - ");
            String _get = c.get("name");
            _builder.append(_get, "   ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("  ");
            _builder.append("- ");
            String string = c.get("implementName");
            _builder.append(string, "     ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("  ");
            _builder.append("- ");
            String _get_2 = c.get("type");
            _builder.append(_get_2, "     ");
            _builder.newLineIfNotEmpty();
            _builder.append("   ");
            _builder.append("  ");
            _builder.append("- ");
            String _get_3 = c.get("null");
            _builder.append(_get_3, "     ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\u30ad\u30fc\u306e\u5b9a\u7fa9\u66f8");
        _builder.newLine();
        _builder.append("---------------");
        _builder.newLine();
        _builder.newLine();
        int _size = m.getKeyModels().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append(".. list-table::");
            _builder.newLine();
            _builder.append("   ");
            _builder.append(":header-rows: 1");
            _builder.newLine();
            _builder.newLine();
            _builder.append("   ");
            _builder.append("* - \u30c7\u30fc\u30bf");
            _builder.newLine();
            Iterable<String> _keyHeader = KeyDefinitionListRstGenerator.keyHeader(m.getKeyModels());
            for (String string : _keyHeader) {
                _builder.append("     ");
                _builder.append("- ");
                _builder.append(string, "     ");
                _builder.newLineIfNotEmpty();
            }
            Set<Map.Entry<IAttribute, List<KeyDefinitionMapping>>> _entrySet = KeyDefinitionListRstGenerator.createData(m).entrySet();
            for (Map.Entry entry : _entrySet) {
                _builder.append("   ");
                _builder.append("* - ");
                String _name_1 = ((IAttribute)entry.getKey()).getName();
                _builder.append(_name_1, "   ");
                _builder.newLineIfNotEmpty();
                List _value = (List)entry.getValue();
                for (KeyDefinitionMapping rm : _value) {
                    _builder.append("   ");
                    _builder.append("  ");
                    _builder.append("- ");
                    String _keyOrder = rm.getKeyOrder();
                    _builder.append(_keyOrder, "     ");
                    _builder.newLineIfNotEmpty();
                }
            }
        } else {
            _builder.append("\u30ad\u30fc\u306f\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            _builder.newLine();
        }
        return _builder;
    }

    private static Iterable<String> keyHeader(KeyModels keys) {
        Functions.Function1<Pair<Integer, KeyModel>, String> _function = new Functions.Function1<Pair<Integer, KeyModel>, String>(){

            public String apply(Pair<Integer, KeyModel> item) {
                String _xifexpression = null;
                boolean _isMasterKey = ((KeyModel)item.getValue()).isMasterKey();
                if (_isMasterKey) {
                    _xifexpression = "N/M";
                } else {
                    Integer _key = (Integer)item.getKey();
                    _xifexpression = Integer.valueOf(_key + 1).toString();
                }
                return _xifexpression;
            }
        };
        return IterableExtensions.map((Iterable)IterableExtensions.indexed((Iterable)keys), (Functions.Function1)_function);
    }
}

