/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.handler;

import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.extension.SerializerFactory;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class GeneratorHandler
extends AbstractHandler {
    private Generator generator;

    public GeneratorHandler(Generator generator) {
        this.generator = generator;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection) {
            IFile file = this.getSelectionFile((IStructuredSelection)selection);
            try {
                Diagram diagram = SerializerFactory.getInstance().deserialize(file.getContents());
                String path = this.getAbsolutePath(file);
                this.generator.execute(path, diagram.findEntityModel());
                TMDPlugin.refreshGenerateResources((String)path);
            }
            catch (CoreException e) {
                TMDPlugin.showErrorDialog((Throwable)e);
            }
            catch (Exception e) {
                TMDPlugin.showErrorDialog((Throwable)e);
            }
        }
        return null;
    }

    private IFile getSelectionFile(IStructuredSelection selection) {
        for (Object obj : selection) {
            if (!(obj instanceof IFile)) continue;
            return (IFile)obj;
        }
        return null;
    }

    private String getAbsolutePath(IFile file) {
        return file.getProject().getLocation().toString();
    }

    public boolean isEnabled() {
        return true;
    }
}

