/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.models;

import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.ui.dialogs.models.ModelEditUtils;

public class EditAttribute {
    private IAttribute originalAttribute;
    private String name = "";
    private boolean edited = false;
    private String description = "";
    private StandardSQLDataType dataType = null;
    private String size = "";
    private String scale = "";
    private Boolean autoIncrement;
    private String defaultValue;
    private String validationRule = "";
    private String lock = "";
    private boolean derivation = false;
    private String derivationRule = "";
    private String implementName = "";
    private boolean nullable = false;
    private boolean added = false;

    public EditAttribute() {
        this.originalAttribute = new Attribute();
        this.added = true;
    }

    public EditAttribute(IAttribute original) {
        this.originalAttribute = original;
        this.name = ModelEditUtils.toBlankStringIfNull(original.getName());
        this.description = ModelEditUtils.toBlankStringIfNull(original.getDescription());
        this.derivationRule = ModelEditUtils.toBlankStringIfNull(original.getDerivationRule());
        this.derivation = original.isDerivation();
        this.lock = ModelEditUtils.toBlankStringIfNull(original.getLock());
        this.validationRule = ModelEditUtils.toBlankStringIfNull(original.getValidationRule());
        this.implementName = ModelEditUtils.toBlankStringIfNull(original.getImplementName());
        DataTypeDeclaration dataTypeDeclaration = original.getDataTypeDeclaration();
        if (dataTypeDeclaration != null) {
            this.dataType = dataTypeDeclaration.getLogicalType();
            this.size = ModelEditUtils.toBlankIfNull(dataTypeDeclaration.getSize());
            this.scale = ModelEditUtils.toBlankIfNull(dataTypeDeclaration.getScale());
            this.autoIncrement = dataTypeDeclaration.getAutoIncrement();
            this.defaultValue = dataTypeDeclaration.getDefaultValue();
        } else {
            this.dataType = null;
            this.size = "";
            this.scale = "";
            this.autoIncrement = null;
            this.defaultValue = null;
        }
        this.nullable = original.isNullable();
        this.added = false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setEdited(true);
    }

    public boolean isNameChanged() {
        return !this.name.equals(this.originalAttribute.getName());
    }

    public IAttribute getOriginalAttribute() {
        if (this.added) {
            this.copyToOriginal();
        }
        return this.originalAttribute;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public boolean isAdded() {
        return this.added;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setEdited(true);
    }

    public StandardSQLDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(StandardSQLDataType dataType) {
        this.dataType = dataType;
        this.setEdited(true);
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
        this.setEdited(true);
    }

    public String getScale() {
        return this.scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
        this.setEdited(true);
    }

    public Boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        this.setEdited(true);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setOriginalAttribute(IAttribute originalAttribute) {
        this.originalAttribute = originalAttribute;
    }

    public String getValidationRule() {
        return this.validationRule;
    }

    public void setValidationRule(String validationRule) {
        this.validationRule = validationRule;
        this.setEdited(true);
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
        this.setEdited(true);
    }

    public boolean isDerivation() {
        return this.derivation;
    }

    public void setDerivation(boolean derivation) {
        this.derivation = derivation;
        this.setEdited(true);
    }

    public String getDerivationRule() {
        return this.derivationRule;
    }

    public void setDerivationRule(String derivationRule) {
        this.derivationRule = derivationRule;
        this.setEdited(true);
    }

    public String getImplementName() {
        return this.implementName;
    }

    public void setImplementName(String implementName) {
        this.implementName = implementName;
        this.setEdited(true);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        this.setEdited(true);
    }

    public void copyTo(IAttribute newAttribute) {
        if (this.dataType != null) {
            Integer size = null;
            Integer scale = null;
            if (this.dataType.isSupportSize()) {
                if (this.size.length() != 0) {
                    size = ModelEditUtils.toInteger(this.size);
                }
            } else {
                size = null;
            }
            if (this.dataType.isSupportScale()) {
                if (this.scale.length() != 0) {
                    scale = ModelEditUtils.toInteger(this.scale);
                }
            } else {
                scale = null;
            }
            DataTypeDeclaration dataTypeDeclaration = new DataTypeDeclaration(this.dataType, size, scale, this.autoIncrement, this.defaultValue);
            newAttribute.setDataTypeDeclaration(dataTypeDeclaration);
        } else {
            newAttribute.setDataTypeDeclaration(null);
        }
        if (this.derivationRule.length() != 0) {
            newAttribute.setDerivationRule(this.derivationRule);
        }
        newAttribute.setDerivation(this.derivation);
        if (this.description.length() != 0) {
            newAttribute.setDescription(this.description);
        }
        if (this.lock.length() != 0) {
            newAttribute.setLock(this.lock);
        }
        if (this.validationRule.length() != 0) {
            newAttribute.setValidationRule(this.validationRule);
        }
        if (this.implementName.length() != 0) {
            newAttribute.setImplementName(this.implementName);
        } else {
            newAttribute.setImplementName(null);
        }
        newAttribute.setNullable(this.nullable);
        newAttribute.setName(this.name);
    }

    public void copyTo(EditAttribute to) {
        to.setDataType(this.getDataType());
        to.setDerivation(this.isDerivation());
        to.setDerivationRule(this.getDerivationRule());
        to.setDescription(this.getDescription());
        to.setImplementName(this.getImplementName());
        to.setLock(this.getLock());
        to.setName(this.getName());
        to.setNullable(this.isNullable());
        to.setScale(this.getScale());
        to.setSize(this.getSize());
        to.setAutoIncrement(this.getAutoIncrement());
        to.setValidationRule(this.getValidationRule());
    }

    protected void copyToOriginal() {
        this.copyTo(this.originalAttribute);
    }

    public Identifier toIdentifier() {
        Identifier identifier = new Identifier(this.name);
        this.copyTo((IAttribute)identifier);
        return identifier;
    }

    public boolean isValid() {
        return this.name != null && this.name.length() > 0;
    }
}

