/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.dialogs.components;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.ui.dialogs.AttributeDialog;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditAttribute;
import jp.sourceforge.tmdmaker.ui.dialogs.models.EditEntity;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntityEditSettingPanel
extends Composite {
    private Label identifierLabel = null;
    private Text identifierText = null;
    private Label typeLabel = null;
    private Button nameAutoCreateCheckBox = null;
    private Label nameLabel = null;
    private Text nameText = null;
    private Button descButton = null;
    private Button btnRadioButton_0;
    private Button btnRadioButton_1;
    private Button btnRadioButton_2;
    private EditEntity entity;
    private Composite entityTypeComposite;

    public EntityEditSettingPanel(Composite parent, int style) {
        super(parent, 0);
        this.initialize();
    }

    private void initializeEntityTypeRadio() {
        EntityType entityType = this.entity.getType();
        this.btnRadioButton_0.setSelection(EntityType.RESOURCE.equals((Object)entityType));
        this.btnRadioButton_1.setSelection(EntityType.EVENT.equals((Object)entityType));
        this.btnRadioButton_2.setSelection(EntityType.LAPUTA.equals((Object)entityType));
        boolean editable = this.entity.isEntityTypeEditable();
        this.btnRadioButton_0.setEnabled(editable);
        this.btnRadioButton_1.setEnabled(editable);
        this.btnRadioButton_2.setEnabled(editable);
    }

    public EntityEditSettingPanel(Composite parent, int style, EditEntity entity) {
        super(parent, style);
        this.entity = entity;
        this.initialize();
    }

    public void updateValue() {
        String identifierName = this.entity.getEditIdentifier().getName();
        String entityName = this.entity.getName();
        this.identifierText.setText(identifierName);
        if (!this.nameAutoCreateCheckBox.getSelection()) {
            this.nameText.setText(entityName);
        }
        this.initializeEntityTypeRadio();
    }

    private void selectAutoCreateCheckBox() {
        if (this.entity.hasAutoCreateEntityName()) {
            this.nameAutoCreateCheckBox.setSelection(true);
            this.nameText.setEnabled(false);
        } else {
            this.nameAutoCreateCheckBox.setSelection(false);
            this.nameText.setEnabled(true);
        }
    }

    private void initialize() {
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalSpan = 2;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = -1;
        gridData.verticalAlignment = 2;
        this.nameAutoCreateCheckBox = new Button((Composite)this, 32);
        this.nameAutoCreateCheckBox.setText(Messages.AutomaticGenerateEntityName);
        this.nameAutoCreateCheckBox.setLayoutData((Object)gridData9);
        new Label((Composite)this, 0);
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText(Messages.EntityName);
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)gridData1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                EntityEditSettingPanel.this.entity.setName(t.getText());
            }
        });
        this.nameAutoCreateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    EntityEditSettingPanel.this.nameText.setEnabled(false);
                    EntityEditSettingPanel.this.nameText.setText(EntityEditSettingPanel.this.entity.generateEntityNameFromIdentifier());
                } else {
                    EntityEditSettingPanel.this.nameText.setEnabled(true);
                }
            }
        });
        new Label((Composite)this, 0);
        this.identifierLabel = new Label((Composite)this, 0);
        this.identifierLabel.setText(Messages.Identifier);
        this.identifierText = new Text((Composite)this, 2048);
        this.identifierText.setLayoutData((Object)gridData);
        this.identifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                EntityEditSettingPanel.this.entity.setIdentifierName(t.getText());
                if (EntityEditSettingPanel.this.nameAutoCreateCheckBox.getSelection()) {
                    String oldName = EntityEditSettingPanel.this.nameText.getText();
                    String newName = EntityEditSettingPanel.this.entity.generateEntityNameFromIdentifier();
                    EntityEditSettingPanel.this.nameText.setText(newName);
                    EntityEditSettingPanel.this.entity.updateTypeAttribute(oldName, newName);
                }
            }
        });
        this.descButton = new Button((Composite)this, 0);
        this.descButton.setText(Messages.DescriptionButton);
        this.descButton.setLayoutData((Object)gridData11);
        this.descButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttribute edited;
                AttributeDialog dialog = new AttributeDialog(EntityEditSettingPanel.this.getShell(), EntityEditSettingPanel.this.entity.getEditIdentifier());
                if (dialog.open() == 0 && (edited = dialog.getEditedValue()).isEdited()) {
                    EntityEditSettingPanel.this.entity.updateEditIdentifier(edited);
                    EntityEditSettingPanel.this.identifierText.setText(edited.getName());
                }
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 5;
        this.typeLabel = new Label((Composite)this, 0);
        this.typeLabel.setText(Messages.EntityType);
        this.entityTypeComposite = new Composite((Composite)this, 0);
        RowLayout rl_composite = new RowLayout(256);
        rl_composite.justify = true;
        this.entityTypeComposite.setLayout((Layout)rl_composite);
        this.entityTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnRadioButton_0 = new Button(this.entityTypeComposite, 16);
        this.btnRadioButton_0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityEditSettingPanel.this.entity.setType(EntityType.RESOURCE);
            }
        });
        this.btnRadioButton_0.setText(Messages.Resource);
        this.btnRadioButton_1 = new Button(this.entityTypeComposite, 16);
        this.btnRadioButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityEditSettingPanel.this.entity.setType(EntityType.EVENT);
            }
        });
        this.btnRadioButton_1.setText(Messages.Event);
        this.btnRadioButton_2 = new Button(this.entityTypeComposite, 16);
        this.btnRadioButton_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityEditSettingPanel.this.entity.setType(EntityType.LAPUTA);
            }
        });
        this.btnRadioButton_2.setText(Messages.Laputa);
        this.selectAutoCreateCheckBox();
        this.updateValue();
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(382, 114));
    }
}

