/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import java.util.List;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.importer.FileImporter;
import jp.sourceforge.tmdmaker.ui.editor.gef3.commands.EntityModelAddCommand;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;

public class FileImportAction
extends Action {
    private GraphicalViewer viewer;
    private FileImporter importer;

    public FileImportAction(GraphicalViewer viewer, FileImporter importer) {
        this.viewer = viewer;
        this.importer = importer;
        this.setText(this.importer.getImporterName());
        this.setId(this.importer.getClass().getName());
    }

    public void run() {
        Viewport viewport = (Viewport)((FreeformGraphicalRootEditPart)this.viewer.getRootEditPart()).getFigure();
        Point p = viewport.getViewLocation();
        FileDialog dialog = new FileDialog(this.viewer.getControl().getShell());
        String filePath = dialog.open();
        if (filePath != null) {
            try {
                List l = this.importer.importEntities(filePath);
                this.viewer.getEditDomain().getCommandStack().execute(this.getCreateCommands(l, p));
            }
            catch (Throwable t) {
                TMDPlugin.showErrorDialog(t);
            }
        }
    }

    private Command getCreateCommands(List<AbstractEntityModel> list, Point p) {
        CompoundCommand ccommand = new CompoundCommand();
        Diagram diagram = (Diagram)this.viewer.getContents().getModel();
        int i = 0;
        for (AbstractEntityModel model : list) {
            EntityModelAddCommand c = new EntityModelAddCommand(diagram, p.x + i, p.y + i);
            i += 5;
            c.setModel(model);
            ccommand.add((Command)c);
        }
        return ccommand.unwrap();
    }
}

