/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.attributelist;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.generate.attributelist.AttributeListModelBuilder;
import jp.sourceforge.tmdmaker.model.generate.attributelist.EntityAttributePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeListCsvGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(AttributeListCsvGenerator.class);
    private static final String[] TITLES = new String[]{"\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u540d\u79f0", "\u6240\u5c5e\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3", "\u6458\u8981", "\u524d\u63d0", "\u6a5f\u5bc6\u6027", "\u8a08\u7b97\u5f0f"};

    public String getGroupName() {
        return "CSV";
    }

    public String getGeneratorName() {
        return "\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u30ea\u30b9\u30c8\u3092CSV\u5f62\u5f0f\u3067\u51fa\u529b";
    }

    public boolean isImplementModelOnly() {
        return false;
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        block14: {
            if (models.isEmpty()) {
                return;
            }
            Map attributes = new AttributeListModelBuilder().build(models);
            File file = new File(rootDir, "attribute_list.csv");
            CSVWriter writer = null;
            try {
                try {
                    writer = new CSVWriter((Writer)new FileWriter(file));
                    writer.writeNext(TITLES);
                    String[] rowData = new String[TITLES.length];
                    for (EntityAttributePair pair : attributes.values()) {
                        IAttribute attribute = pair.getAttribute();
                        rowData[0] = attribute.getName();
                        rowData[1] = pair.getModel().getName();
                        rowData[2] = attribute.getDescription();
                        rowData[3] = attribute.getValidationRule();
                        rowData[4] = attribute.getLock();
                        rowData[5] = attribute.getDerivationRule();
                        writer.writeNext(rowData);
                    }
                    writer.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    if (writer == null) break block14;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        logger.warn(e2.getMessage());
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        logger.warn(e.getMessage());
                    }
                }
            }
        }
    }
}

