/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpolicy.CombinationTableComponentEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;

public class CombinationTableEditPart
extends AbstractEntityModelEditPart<CombinationTable> {
    public CombinationTableEditPart(CombinationTable table) {
        this.setModel(table);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        EntityFigure entityFigure = (EntityFigure)figure;
        CombinationTable table = (CombinationTable)this.getModel();
        entityFigure.setEntityType(table.getCombinationTableType().getLabel());
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        entityFigure.addRelationship(this.extractRelationship(table));
        entityFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected ModelAppearance getAppearance() {
        return ModelAppearance.COMBINATION_TABLE;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CombinationTableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }
}

