/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.extension.DialectProviderFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DatabaseSettingPanel
extends Composite {
    private Label databaseNameLabel = null;
    private Combo databaseCombo = null;

    public DatabaseSettingPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.databaseNameLabel = new Label((Composite)this, 0);
        this.databaseNameLabel.setText(Messages.DatabaseName);
        this.setLayout((Layout)gridLayout);
        this.createDatabaseCombo();
        this.setSize(new Point(217, 40));
    }

    private void createDatabaseCombo() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 4;
        this.databaseCombo = new Combo((Composite)this, 8);
        this.databaseCombo.setLayoutData((Object)gridData);
        this.databaseCombo.add("");
        for (String database : DialectProviderFactory.getDialectProvider().getDatabaseList()) {
            this.databaseCombo.add(database);
        }
    }

    public void initializeValue(String databaseName) {
        int index = this.databaseCombo.indexOf(databaseName);
        if (index == -1) {
            index = 0;
        }
        this.databaseCombo.select(index);
    }

    public String getSelectedDatabaseName() {
        int index = this.databaseCombo.getSelectionIndex();
        return this.databaseCombo.getItem(index);
    }
}

