/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.property;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.MappingList;
import jp.sourceforge.tmdmaker.model.MultivalueOrEntity;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.property.AbstractPropertySource;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class AbstractEntityModelPropertySource
extends AbstractPropertySource {
    private static final String IMPLEMENT = "Implement";
    private static final String ENTITY_TYPE = "EntityType";
    private static final String IMPLEMENT_NAME = "ImplementName";
    private static final String NAME = "Name";
    private AbstractEntityModel model;
    private static IPropertyDescriptor[] propertyFields = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Name", Messages.ModelName), new TextPropertyDescriptor((Object)"ImplementName", Messages.ImplementationName), new TextPropertyDescriptor((Object)"EntityType", Messages.EntityType), new TextPropertyDescriptor((Object)"Implement", Messages.Implementation)};

    public AbstractEntityModelPropertySource(TMDEditor editor, AbstractEntityModel model) {
        super(editor);
        this.model = model;
    }

    public Object getEditableValue() {
        return this.model;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return propertyFields;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(NAME)) {
            return this.canonicalize(this.model.getName());
        }
        if (id.equals(IMPLEMENT_NAME)) {
            return this.canonicalize(this.model.getImplementName());
        }
        if (id.equals(IMPLEMENT)) {
            return this.model.isNotImplement() ? Messages.NotToImplement : Messages.Implementation;
        }
        if (id.equals(ENTITY_TYPE)) {
            if (this.model instanceof CombinationTable) {
                return Messages.CombinationTable;
            }
            if (this.model instanceof SubsetEntity) {
                return Messages.Subset;
            }
            if (this.model instanceof VirtualEntity) {
                return Messages.VirtualEntity;
            }
            if (this.model instanceof MultivalueOrEntity) {
                return Messages.MultivalueOR;
            }
            if (this.model instanceof Detail) {
                return Messages.MultivalueAndDetail;
            }
            if (this.model instanceof RecursiveTable) {
                return Messages.RecursiveTable;
            }
            if (this.model instanceof MappingList) {
                return Messages.MappingList;
            }
            if (this.model instanceof Laputa) {
                return Messages.Laputa;
            }
        }
        return null;
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object value) {
        return null;
    }
}

