/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.figure.MemoFigure;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.other.Memo;
import jp.sourceforge.tmdmaker.ui.command.MemoChangeCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import jp.sourceforge.tmdmaker.util.ConstraintConverter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MemoEditPart
extends AbstractModelEditPart<Memo> {
    public MemoEditPart(Memo model) {
        this.setModel(model);
    }

    @Override
    protected void refreshVisuals() {
        logger.debug(this.getClass() + "#refreshVisuals()");
        Constraint constraint = ((Memo)this.getModel()).getConstraint();
        Rectangle bounds = ConstraintConverter.toRectangle(constraint);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        this.updateFigure(this.getFigure());
    }

    protected IFigure createFigure() {
        logger.debug(this.getClass() + "#createFigure()");
        MemoFigure figure = new MemoFigure();
        return figure;
    }

    @Override
    protected void updateFigure(IFigure figure) {
        logger.debug(this.getClass() + "#updateFigure()");
        MemoFigure memoFigure = (MemoFigure)this.getFigure();
        Memo memo = (Memo)this.getModel();
        memoFigure.setMemo(memo.getMemo());
        memoFigure.setColor(this.getForegroundColor(), this.getBackgroundColor());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        this.onDirectEdit();
    }

    @Override
    protected void onDirectEdit() {
        logger.debug(this.getClass() + "#onDirectEdit()");
        MemoFigure figure = (MemoFigure)this.getFigure();
        TextFlow label = figure.getMemoTextFlow();
        MemoDirectEditManager manager = new MemoDirectEditManager((GraphicalEditPart)this, label);
        manager.show();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug(this.getClass() + "#propertyChange() " + evt.getPropertyName());
        if (evt.getPropertyName().equals("p_memo")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new MemoDirectEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MemoDeleteEditPolicy());
    }

    @Override
    public boolean canAutoSize() {
        return true;
    }

    @Override
    protected ModelAppearance getAppearance() {
        return ModelAppearance.MEMO_COLOR;
    }

    private static class Locator
    implements CellEditorLocator {
        private TextFlow label;

        public Locator(TextFlow label) {
            this.label = label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Point pref = text.computeSize(-1, -1);
            Rectangle rect = this.label.getBounds().getCopy();
            this.label.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x - 1, rect.y - 1, pref.x + 1, pref.y + 1);
        }
    }

    private static class MemoDeleteCommand
    extends Command {
        private Diagram diagram;
        private Memo memo;

        public MemoDeleteCommand(Diagram diagram, Memo memo) {
            this.diagram = diagram;
            this.memo = memo;
        }

        public void execute() {
            this.diagram.removeChild((ConnectableElement)this.memo);
        }

        public void undo() {
            this.diagram.addChild((ConnectableElement)this.memo);
        }
    }

    private static class MemoDeleteEditPolicy
    extends ComponentEditPolicy {
        private MemoDeleteEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            return new MemoDeleteCommand((Diagram)this.getHost().getParent().getModel(), (Memo)this.getHost().getModel());
        }
    }

    private static class MemoDirectEditManager
    extends DirectEditManager {
        public MemoDirectEditManager(GraphicalEditPart source, TextFlow label) {
            super(source, TextCellEditor.class, (CellEditorLocator)new Locator(label), (Object)label);
        }

        protected CellEditor createCellEditorOn(Composite composite) {
            return new TextCellEditor(composite, 66);
        }

        protected void initCellEditor() {
            TextFlow label = (TextFlow)this.getDirectEditFeature();
            String initialLabelText = label.getText();
            this.getCellEditor().setValue((Object)initialLabelText);
        }
    }

    private static class MemoDirectEditPolicy
    extends DirectEditPolicy {
        private MemoDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            logger.debug(((Object)((Object)this)).getClass() + "#getDirectEditCommand()");
            String newValue = (String)request.getCellEditor().getValue();
            Memo memo = (Memo)this.getHost().getModel();
            return new MemoChangeCommand(memo, newValue);
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
            logger.debug(((Object)((Object)this)).getClass() + "#showCurrentEditValue()");
            MemoFigure figure = (MemoFigure)this.getHostFigure();
            String value = (String)request.getCellEditor().getValue();
            figure.setMemo(value);
        }
    }
}

