/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.MultivalueAndAggregator;
import jp.sourceforge.tmdmaker.model.MultivalueAndSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;

public class RelatedRelationship
extends AbstractConnectionModel {
    private transient RelationHelperFactory factory = null;

    private RelationHelperFactory getRelationHelperFactory() {
        if (this.factory == null) {
            this.factory = new RelationHelperFactory();
        }
        return this.factory;
    }

    public RelatedRelationship(ConnectableElement source, ConnectableElement target) {
        this.setSource(source);
        this.setTarget(target);
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public String getSourceName() {
        return this.getRelationHelperFactory().getRelationHelper().getSourceName();
    }

    @Override
    public String getTargetName() {
        return this.getRelationHelperFactory().getRelationHelper().getTargetName();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    private class MultivalueAnd2AggregatorRelationHelper
    extends RelationHelper {
        private MultivalueAnd2AggregatorRelationHelper() {
        }

        @Override
        public String getSourceName() {
            MultivalueAndAggregator aggregator = (MultivalueAndAggregator)RelatedRelationship.this.getTarget();
            return aggregator.getSuperset().getName();
        }

        @Override
        public String getTargetName() {
            return super.getSourceName();
        }
    }

    private class MultivalueAndSuperset2AggregatorRelationHelper
    extends RelationHelper {
        private MultivalueAndSuperset2AggregatorRelationHelper() {
        }

        @Override
        public String getTargetName() {
            MultivalueAndAggregator aggregator = (MultivalueAndAggregator)RelatedRelationship.this.getTarget();
            return String.valueOf(aggregator.getHeader().getName()) + "," + aggregator.getDetail().getName();
        }
    }

    private class RelationHelper {
        private RelationHelper() {
        }

        public String getSourceName() {
            return RelatedRelationship.this.getSource().getName();
        }

        public String getTargetName() {
            return RelatedRelationship.this.getTarget().getName();
        }

        /* synthetic */ RelationHelper(RelationHelper relationHelper, RelationHelper relationHelper2) {
            this();
        }
    }

    private class RelationHelperFactory {
        private RelationHelperFactory() {
        }

        public RelationHelper getRelationHelper() {
            ConnectableElement model = RelatedRelationship.this.getSource();
            if (model instanceof AbstractConnectionModel) {
                return new TableRelationHelper();
            }
            if (model instanceof MultivalueAndSuperset) {
                return new MultivalueAndSuperset2AggregatorRelationHelper();
            }
            model = RelatedRelationship.this.getTarget();
            if (model instanceof MultivalueAndAggregator) {
                return new MultivalueAnd2AggregatorRelationHelper();
            }
            if (model instanceof VirtualSuperset) {
                return new VirtualSupersetType2VirtualSupersetRelationHelper();
            }
            return new RelationHelper(null, null);
        }
    }

    private class TableRelationHelper
    extends RelationHelper {
        private TableRelationHelper() {
        }

        private AbstractConnectionModel getConnection() {
            return (AbstractConnectionModel)RelatedRelationship.this.getSource();
        }

        @Override
        public String getSourceName() {
            return this.getConnection().getSourceName();
        }

        @Override
        public String getTargetName() {
            return this.getConnection().getTargetName();
        }
    }

    private class VirtualSupersetType2VirtualSupersetRelationHelper
    extends RelationHelper {
        private VirtualSupersetType2VirtualSupersetRelationHelper() {
        }

        @Override
        public String getSourceName() {
            return RelatedRelationship.this.getTarget().getName();
        }

        @Override
        public String getTargetName() {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            VirtualSupersetType type = (VirtualSupersetType)RelatedRelationship.this.getSource();
            for (AbstractEntityModel m : type.getSubsetList()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(m.getName());
            }
            return builder.toString();
        }
    }
}

