/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sourceforge.tmdmaker.dialog.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractSubsetTypeEditPart;
import jp.sourceforge.tmdmaker.figure.SubsetTypeFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSubsetAddCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSubsetDisconnectCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSupersetTypeChangeCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class VirtualSupersetTypeEditPart
extends AbstractSubsetTypeEditPart<VirtualSupersetType> {
    public VirtualSupersetTypeEditPart(VirtualSupersetType type) {
        this.setModel(type);
    }

    @Override
    protected void updateFigure(IFigure figure) {
        SubsetTypeFigure sf = (SubsetTypeFigure)figure;
        VirtualSupersetType model = (VirtualSupersetType)this.getModel();
        sf.setVertical(model.isVertical());
        sf.setSameType(model.isApplyAttribute());
    }

    @Override
    protected void onDoubleClicked() {
        VirtualSupersetType type = (VirtualSupersetType)this.getModel();
        VirtualSuperset superset = type.getSuperset();
        Diagram diagram = superset.getDiagram();
        List list = type.getSubsetList();
        VirtualSupersetCreateDialog dialog = new VirtualSupersetCreateDialog(this.getViewer().getControl().getShell(), diagram, superset, list);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            VirtualSuperset edited = dialog.getEditedValue();
            ccommand.add((Command)new ModelEditCommand((AbstractEntityModel)superset, (AbstractEntityModel)edited));
            ccommand.add((Command)new VirtualSupersetTypeChangeCommand(superset.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
            List<AbstractEntityModel> notSelection = dialog.getNotSelection();
            List<AbstractEntityModel> selection = dialog.getSelection();
            List selectedList = superset.getVirtualSubsetList();
            for (AbstractEntityModel s : selection) {
                if (selectedList.contains(s)) continue;
                ccommand.add((Command)new VirtualSubsetAddCommand(superset, s));
            }
            for (AbstractEntityModel m : superset.getVirtualSubsetList()) {
                if (!notSelection.contains(m)) continue;
                ccommand.add((Command)new VirtualSubsetDisconnectCommand(superset, m));
            }
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_superset_type")) {
            this.refreshVisuals();
        } else {
            super.propertyChange(evt);
        }
    }
}

