/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CPOpUtils {
    public static String[] createArrayWithFirst(String[] oldNames, String newFirstName, int maxLength) {
        ArrayList<String> newNames = new ArrayList<String>(maxLength + 1);
        if (oldNames != null) {
            newNames.addAll(Arrays.asList(oldNames));
        }
        newNames.remove(newFirstName);
        newNames.add(0, newFirstName);
        if (newNames.size() > maxLength) {
            newNames.remove(newNames.size() - 1);
        }
        return newNames.toArray(new String[newNames.size()]);
    }

    public static IStatus validateDirectory(File targetDirectory, IProgressMonitor monitor) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            return new Status(4, "com.instantiations.assist.eclipse", 0, "Destination must be a directory: " + targetDirectory.getPath(), null);
        }
        if (!targetDirectory.exists()) {
            monitor.beginTask("Creating " + targetDirectory.getPath(), 1);
            boolean success = targetDirectory.mkdirs();
            monitor.done();
            if (!success) {
                return new Status(4, "com.instantiations.assist.eclipse", 0, "Could not create destination directory: " + targetDirectory.getPath(), null);
            }
        }
        return null;
    }

    public static IStatus validateFile(File targetFile, boolean overwriteFile, IProgressMonitor monitor) {
        IStatus result;
        File parentDirectory = targetFile.getParentFile();
        if (parentDirectory != null && (result = CPOpUtils.validateDirectory(parentDirectory, monitor)) != null) {
            return result;
        }
        if (targetFile.exists() && targetFile.isDirectory()) {
            return new Status(4, "com.instantiations.assist.eclipse", 0, "Destination must be a file: " + targetFile.getPath(), null);
        }
        if (targetFile.exists()) {
            if (!targetFile.canWrite()) {
                return new Status(4, "com.instantiations.assist.eclipse", 0, "Cannot write to file: " + targetFile.getPath(), null);
            }
            if (!overwriteFile) {
                return new Status(4, "com.instantiations.assist.eclipse", 0, "File already exists: " + targetFile.getPath(), null);
            }
        }
        return null;
    }
}

