/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.model;

import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditTable;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;

public class EditEntity
extends EditTable {
    public static final String PROPERTY_IDENTIFIER = "_edit_property_identifier";
    public static final String PROPERTY_UP_IDENTIFIER = "_edit_property_up_identifier";
    protected EditAttribute editIdentifier;
    private boolean latuta;
    private boolean detail;

    public EditEntity(Entity entity) {
        super(entity);
        this.editIdentifier = new EditAttribute(entity.getIdentifier());
    }

    public EditEntity(Detail entity) {
        super(entity);
        this.editIdentifier = new EditAttribute(entity.getDetailIdentifier());
        this.detail = true;
    }

    public EditEntity(Laputa entity) {
        super(entity);
        this.editIdentifier = new EditAttribute(entity.getIdentifier());
        this.latuta = true;
    }

    @Override
    public void uptoIdentifier(int index) {
        EditAttribute toIdentifier = (EditAttribute)this.attributes.get(index);
        EditAttribute tempIdentifier = new EditAttribute();
        this.editIdentifier.copyTo(tempIdentifier);
        toIdentifier.copyTo(this.editIdentifier);
        tempIdentifier.copyTo(toIdentifier);
        this.firePropertyChange(PROPERTY_UP_IDENTIFIER, tempIdentifier, toIdentifier);
    }

    public EditAttribute getEditIdentifier() {
        return this.editIdentifier;
    }

    public void updateEditIdentifier(EditAttribute identifier) {
        identifier.copyTo(this.editIdentifier);
        this.firePropertyChange(PROPERTY_IDENTIFIER, null, this.editIdentifier);
    }

    public void setIdentifierName(String name) {
        this.editIdentifier.setName(name);
        this.firePropertyChange(PROPERTY_IDENTIFIER, null, this.editIdentifier);
    }

    @Override
    public boolean canUpToIdentifier() {
        return true;
    }

    protected void setEditIdentifier(EditAttribute editIdentifier) {
        this.editIdentifier = editIdentifier;
    }

    public boolean isLatuta() {
        return this.latuta;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public boolean isEntity() {
        return !this.latuta && !this.detail;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getEditIdentifier().getName().length() > 0;
    }

    @Override
    protected void copySpecialTo(AbstractEntityModel to) {
        Identifier newIdentifier;
        AbstractEntityModel edited;
        if (this.isEntity()) {
            edited = (Entity)to;
            newIdentifier = new Identifier();
            this.getEditIdentifier().copyTo(newIdentifier);
            ((Entity)edited).setIdentifier(newIdentifier);
        }
        if (this.isDetail()) {
            edited = (Detail)to;
            newIdentifier = new Identifier();
            this.getEditIdentifier().copyTo(newIdentifier);
            ((Detail)edited).setDetailIdentifier(newIdentifier);
            edited.setEntityType(this.getType());
        }
    }
}

